new;
library gdr,pgraph;
gdrSet;

N = 70; tau = 0.5; rho = sin(pi/2*tau);

u1 = seqa(0.01,0.98/N,N+1); u2 = u1';
x1 = seqa(-3,6/N,N+1); x2 = x1';

pdf1 = pdfCopulaNormal2(u1,u2,rho);
pdf2 = pdfCopulaNormal2(cdfn(x1),cdfn(x2),rho) .* pdfn(x1) .* pdfn(x2);
pdf3 = pdfCopulaLogisticGumbel(u1,u2);
pdf4 = pdfCopulaLogisticGumbel(cdfn(x1),cdfn(x2)) .* pdfn(x1) .* pdfn(x2);

graphset;
  begwind;
  window(2,2,1);
  _pnum = 2; 
  _paxht = 0.30; _pnumht = 0.20; _pframe = 0; _plwidth = 10; _ptitlht = 0.30;
  _pzclr = 1|2|3|4|5|6|0|1|2|3|4|5|6|0|1|2|3|4|5|6|0;

  fonts("simplex simgrma");
  xtics(0,1,0.2,2); ytics(0,1,0.2,2);
  xlabel("\216U]@[0,1@]["); ylabel("\216U]@[0,1@][");
  ztics(0,15,5,0);

  setwind(1);
    title("\216Copule Normale");
    surface(u1',u2',pdf1');

  setwind(2);
    title("\216Copule Logistic Gumbel");
    surface(u1',u2',pdf3');

  xtics(-3,3,1,0); ytics(-3,3,1,0);
  xlabel("\216N(0,1)"); ylabel("\216N(0,1)"); title("");
  ztics(0,0.20,0.05,0);

  setwind(3);
    surface(x1',x2',pdf2');

  setwind(4);
    surface(x1',x2',pdf4');

    graphprt("-c=1 -cf=sklar5.eps");

  endwind;


