new;
library gdr,pgraph;
gdrSet;

dataset = "lme";
let vars  = AL AL-15;

data = ln(LoadData(dataset,vars));
data = packr(data - lag1(data));

{u,C1} = cdfCopulaDeheuvels(data,"tmp");
u1 = u[seqa(1,3,rows(u)/3)]|1;
if rows(u1)%2 == 0;
  u1 = u1|1;
endif;
u2 = u1;
C1 = readCopulaDeheuvels("tmp",u,u1,u2);

rho = submat(corrx(data),1,2);
C2 = cdfCopulaNormal2(u1,u2',rho);

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  _pnum = 2;
  _plev = seqa(.05,.05,19);
  xlabel("\216" $+ vars[1]);
  ylabel("\216" $+ vars[2]);

  setwind(1);
    _pzclr = 9;
    contour(u1',u2,C1');

  setwind(2);  
    _pzclr = 12;
    contour(u1',u2,C2');

  graphprt("-c=1 -cf=sklar45.eps");

  endwind;
