new;
library gdr,pgraph;
gdrSet;

tau = 0.75;
rho = sin(pi/2*tau);
nu = 1;

ns = 1024;

proc FindParameterFrank(theta);
  retp((-KendallCopulaFrank(theta) + tau)^2);
endp;

{thetaFrank,f0,g0,retcode} = Qnewton(&FindParameterFrank,7);

proc FindParameterGumbel(theta);
  retp((-KendallCopulaGumbel(theta) + tau)^2);
endp;

{thetaGumbel,f0,g0,retcode} = Qnewton(&FindParameterGumbel,2);

u1 = zeros(ns,4); u2 = zeros(ns,4);

rndCopulaSobol(3);
{u1[.,1],u2[.,1]} = rndCopulaNormal2(rho,ns);

rndCopulaSobol(3);
{u1[.,2],u2[.,2]} = rndCopulaStudent2(rho,nu,ns);

rndCopulaSobol(3);
{u1[.,3],u2[.,3]} = rndCopulaFrank(thetaFrank,ns);

rndCopulaSobol(3);
{u1[.,4],u2[.,4]} = rndCopulaGumbel(thetaGumbel,ns);

graphset;
  begwind;
  window(2,2,0);
    _pdate = ""; _pnum = 2; _pframe = 0; _pcross = 1;
    _plctrl = -1; _pstype = 4; _psymsiz = 5;
    _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.30;
    fonts("simplex simgrma");
    xlabel("\216U]1["); ylabel("\216U]2[");
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);
 
  setwind(1);
    title("\216Copule Normale");
    _pcolor = 1;
    xy(u1[.,1],u2[.,1]);

  setwind(2);
    title("\216Copule Student t]1[");
    _pcolor = 2;
    xy(u1[.,2],u2[.,2]);

  setwind(3);
    title("\216Copule Frank");
    _pcolor = 12;
    xy(u1[.,3],u2[.,3]);

  setwind(4);
    title("\216Copule Gumbel");
    _pcolor = 5;
    xy(u1[.,4],u2[.,4]);

    graphprt("-c=1 -cf=sklar41.eps");

  endwind;

