new;
library gdr,pgraph;
gdrSet;

tau  = 0|0.5|0.75|0.90;
theta = 1./(1-tau);
mu = 0; sigma = 1; xi1 = 1; xi2 = 1.2;

x1 = seqa(-0.9,0.01,1001); x2 = seqa(-0.8,0.01,1001)';
u1 = cdfGEV(x1,mu,sigma,xi1); u2 = cdfGEV(x2,mu,sigma,xi2);
pdfx1 = pdfGEV(x1,mu,sigma,xi1); pdfx2 = pdfGEV(x2,mu,sigma,xi2);

pdf1 = pdfCopulaGumbel(u1,u2,theta[1]) .* pdfx1 .* pdfx2;
pdf2 = pdfCopulaGumbel(u1,u2,theta[2]) .* pdfx1 .* pdfx2;
pdf3 = pdfCopulaGumbel(u1,u2,theta[3]) .* pdfx1 .* pdfx2;
pdf4 = pdfCopulaGumbel(u1,u2,theta[4]) .* pdfx1 .* pdfx2;

graphset;
  begwind;
  window(2,2,0);
  _pnum = 2; _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.30;
  fonts("simplex simgrma");
  _plev = seqa(0.01,0.03,10); _pzclr = 0|0;
  xtics(-1,5,1,2); ytics(-1,5,1,2);

  i = 1;
  do until i > 4;
    setwind(i);
      str1 = ftos(theta[i],"\216\202Q\201 = %lf",3,2);
      str1 = strput(",",str1,strindx(str1,".",1));
      str2 = ftos(tau[i],"\202t\201 = %lf",3,2);
      str2 = strput(",",str2,strindx(str2,".",1));
      title(str1 $+ " et " $+ str2);
      contour(x1',x2',varget(ftos(i,"pdf%lf",1,0))');
      i = i + 1;
  endo;

  graphprt("-c=1 -cf=sklar34.eps");

  endwind;