new;
library gdr,pgraph;
gdrSet;

alpha = 0.50~0.75~0.95~0.999;
rho = -0.75;
nu = 1;

u1 = 0.001|seqa(0.01,0.01,99)|0.999;
u2 = qrCopulaNormal(u1,rho,alpha);
u3 = qrCopulaStudent(u1,rho,nu,alpha);

x1 = cdfni(u1);
x2 = cdfni(u2);
x3 = cdfni(u3);

y1 = cdfni(u1);
y2 = cdfti(u2,2);
y3 = cdfti(u3,2);

graphset;
  begwind;
  window(2,3,1);

  _pframe = 0; _pltype = 6|1|3|4; _plwidth = 10; _pcolor = 2|1|4|0;
  _pnum = 2; _paxht = 0.30; _pnumht = 0.25;
  fonts("simplex simgrma");

  setwind(1);
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);
    xlabel("\216U]1["); ylabel("\216U]2[");
    _pmsgstr = "Copule Normale";
    _pmsgctl = 3~2~0.35~0~2~0~5;
    xy(u1,u2);
    _pmsgctl = 0;

  setwind(2);
    xtics(-3,3,1,0); ytics(-2,3,1,0);
    xlabel("\216N(0,1)"); ylabel("\216N(0,1)");
    xy(x1,x2);

  setwind(3);
    xtics(-3,3,1,0); ytics(-4,6,2,0);
    xlabel("\216N(0,1)"); ylabel("\216t]2[");
    xy(y1,y2);

  setwind(4);
    xtics(0,1,0.2,2); ytics(0,1,0.2,2);
    xlabel("\216U]1["); ylabel("\216U]2[");
    _pmsgstr = "Copule Student t]1[";
    _pmsgctl = 3~2~0.35~0~2~0~5;
    xy(u1,u3);
    _pmsgctl = 0;

  setwind(5);
    xtics(-3,3,1,0); ytics(-2,3,1,0);
    xlabel("\216N(0,1)"); ylabel("\216N(0,1)");
    xy(x1,x3);

  setwind(6);
    xtics(-3,3,1,0); ytics(-4,6,2,0);
    xlabel("\216N(0,1)"); ylabel("\216t]2[");
    _plegstr = "\202a\201 = 0.5\000\202a\201 = 0.75\000\202a\201 = 0.95\000\202a\201 = 0.999";
    _plegctl = {2 6 4 1.25};
    xy(y1,y3);
    
    graphprt("-c=1 -cf=sklar32.eps");
  endwind;