new;
library gdr,pgraph;
gdrSet;

rho = -0.999999~seqa(-0.9,0.3,7)'~0.99999999;
u = 0.001|seqa(0.01,0.01,99)|0.991|0.992|0.993|0.994|0.995|0.999999;
nu = 4;

proc cdfCopula(u1,u2);
  local cdf,i;
  cdf = zeros(rows(u1),cols(rho));
  i = 1;
  do until i > cols(rho);
    cdf[.,i] = cdfCopulaStudent2(u1,u2,rho[i],nu);
    i = i + 1;
  endo;
  retp( cdf );
endp;

lambda = qqUpperCopula(&cdfCopula,u);
lambda[rows(lambda),.] = 2*cdftc(sqrt(nu+1).*sqrt(1-rho)./sqrt(1+rho),nu+1);

graphset;
  _pdate = "";
  _pcross = 1; _pframe = 0; _pnum = 2; _plwidth = 10;
  _pltype = 6|1|1|1|6|3|3|3|6;
  _pstype = 8|8|9|10|8|10|9|8|8;
  _plctrl = 0|5|5|5|0|5|5|5|0;
  _pcolor = seqa(0,1,9);
  fonts("simplex simgrma");

  xtics(0,1,0.2,2);
  ytics(0,1,0.2,2);

  xlabel("\216\202a\201");
  e = ones(cols(lambda),1);
  _pline = e.*(1~6~0.97)~lambda[rows(lambda),.]'~e~lambda[rows(lambda),.]'~e.*(1~0~15);
  _plegstr = "\202r\201 = -1\000\202r\201 = -0,9\000\202r\201 = -0,6\000\202r\201 = -0,3\000"\
             "\202r\201 = 0\000\202r\201 = 0,3\000\202r\201 = 0,6\000\202r\201 = 0,9\000"\
             "\202r\201 = 1";
  _plegctl = {2 3.5 1.25 2};
  graphprt("-c=1 -cf=sklar27.eps");
  xy(u,lambda); 



  