new;
library gdr,pgraph;
gdrSet;

tauGumbel = 0~0.25~0.50~0.90;
thetaGumbel = 1./(1-tauGumbel);

tauClayton = 0.00001~0.25~0.50~0.90;
thetaClayton = 2*tauClayton./(1-tauClayton);

proc Copula1(u1,u2);
  retp( cdfCopulaGumbel(u1,u2,thetaGumbel) );
endp;

proc Copula2(u1,u2);
  retp( cdfCopulaClayton(u1,u2,thetaClayton) );
endp;

__macheps = 1e-10;
u = __macheps|seqa(0.001,0.001,998)|1-__macheps;
lambdaUpperGumbel = qqUpperCopula(&Copula1,u);
lambdaLowerGumbel = qqLowerCopula(&Copula1,u);
lambdaUpperClayton = qqUpperCopula(&Copula2,u);
lambdaLowerClayton = qqLowerCopula(&Copula2,u);

graphset;
  begwind;
  window(2,2,0);
  _pdate = ""; _pnum = 2; _pframe = 0;
  _paxht = 0.30; _pnumht = 0.20; _plwidth = 10; _ptitlht = 0.30; _pltype = 6|1|3|4; _pcolor = 2|1|4|0;
  fonts("simplex simgrma");
  xlabel("\216\202a\201");
  xtics(0,1,0.2,2); 
  ytics(0,1,0.2,2);


  setwind(1);
    ylabel("\216\202l\201]U[(\202a\201)");
    title("\216Copule Gumbel");
    xy(u,lambdaUpperGumbel);

  setwind(2);
    title("\216Copule Clayton");
    xy(u,lambdaUpperClayton);

  setwind(3);
    title("");
    ylabel("\216\202l\201]L[(\202a\201)");
    xy(u,lambdaLowerGumbel);

  setwind(4);
    _plegstr = "\202t\201 = 0\000\202t\201 = 0,25\000\202t\201 = 0,50\000\202t\201 = 0,90";
    _plegctl = {2 5 6 2};
    xy(u,lambdaLowerClayton);
    graphprt("-c=1 -cf=sklar22.eps");

  endwind;





