new;
library gdr,pgraph;
gdrSet;

_intord = 24;
declare matrix theta,_copula_;

thetaVector = (seqa(-0.99,1.98/503,504)) ~                  /* Parameter values of the Normal Copula */
              (0.001|0.002|0.005|seqa(0.01,0.20,501)) ~    /* Parameter values of the Plackett Copula */
              (-30|seqa(-25,0.09,503)) ~                   /* Parameter values of the Frank Copula */
              (0.001|0.002|0.005|seqa(0.01,0.20,501)) ~    /* Parameter values of the Clayton Copula */
              (seqa(1,0.01,501)|10|20|30) ~                /* Parameter values of the Gumbel Copula */
              (seqa(0.01,0.20,504)) ~                      /* Parameter values of the Galambos Copula */
              (seqa(0.01,0.20,504)) ~                      /* Parameter values of the Husler-Reiss Copula */
              (seqa(-0.99,1.98/503,504));                  /* Parameter values of the FGM Copula */

proc cdfCopula(u1,u2);
  if _copula_ == 1;
    retp( cdfCopulaNormal2(u1,u2,theta) );
  elseif _copula_ == 2;
    retp( cdfCopulaPlackett(u1,u2,theta) );
  elseif _copula_ == 3;
    retp( cdfCopulaFrank(u1,u2,theta) );
  elseif _copula_ == 4;
    retp( cdfCopulaClayton(u1,u2,theta) );
  elseif _copula_ == 5;
    retp( cdfCopulaGumbel(u1,u2,theta) );
  elseif _copula_ == 6;
    retp( cdfCopulaGalambos(u1,u2,theta) );
  elseif _copula_ == 7;
    retp( cdfCopulaHuslerReiss(u1,u2,theta) );
  elseif _copula_ == 8;
    retp( cdfCopulaFGM(u1,u2,theta) );
  endif;
endp;

tau = zeros(504,8);
varrho = zeros(504,8);

_copula_ = 1;
do until _copula_ > 8;
  i = 1;
  do until i > 504;

    theta = thetaVector[i,_copula_];

    if _copula_ == 1;
      tau[i,_copula_] = KendallCopulaNormal(theta);
    elseif _copula_ == 3;
      tau[i,_copula_] = KendallCopulaFrank(theta);
    elseif _copula_ == 3;
      tau[i,_copula_] = KendallCopulaClayton(theta);
    elseif _copula_ == 5;
      tau[i,_copula_] = KendallCopulaGumbel(theta);
    elseif _copula_ == 8;
      tau[i,_copula_] = KendallCopulaFGM(theta);
    else;
      tau[i,_copula_] = KendallCopula(&cdfCopula);
    endif;

    if _copula_ == 1;
      varrho[i,_copula_] = SpearmanCopulaNormal(theta);
    elseif _copula_ == 3;
      varrho[i,_copula_] = SpearmanCopulaFrank(theta);
    elseif _copula_ == 8;
      varrho[i,_copula_] = SpearmanCopulaFGM(theta);
    else;
      varrho[i,_copula_] = SpearmanCopula(&cdfCopula);
    endif;

    i = i + 1;
  endo;
  _copula_ = _copula_ + 1;
endo;

tau_ = seqa(-1,0.01,201);
{minRho,maxRho} = KendallSpearmanBounds(tau_);

N = 1000;
x = seqa(-1,2/N,N+1);
y = miss(zeros(N+1,cols(varrho)),0);
i = 1;
do until i > cols(varrho);
  e = selif(seqa(1,1,rows(x)),x.>= minc(tau[.,i]) .and x.<= maxc(tau[.,i]));
  data = sortc(tau[.,i]~varrho[.,i],1);
  c = csspline(data[.,1],data[.,2],1,1);
  y[e,i] = fspline(c,x[e]);
  i = i + 1;
endo;

graphset;
  begwind;
  makewind(9-1,6.855-1,0.5,0.5,1);
  makewind(9,6.855,0,0,1);

  setwind(1);
    _pcross = 1; _pnum = 2; _pframe = 0;
    xtics(-1,1,0.5,2);
    ytics(-1,1,0.5,2);

    _pcolor = 12; _plwidth = 10; _pltype = 6;
    e = ones(rows(tau_),1);
    _pline = e.*(1~6)~tau_~maxRho~tau_-0.5~maxRho+2~e.*(1~4~2) |
             e.*(1~6)~tau_~minRho~tau_+0.5~minRho-2~e.*(1~4~2) ;
    indx = seqa(1,1,201);
    _pline = submat(_pline,indx | rows(tau_)+indx,0);
    max = maxc(y');
    min = minc(y');
    e = ones(rows(x),1);
    _pline = _pline|e.*(1~6)~x~min~x~max~e.*(1~1~10);

    xy(tau_,minRho~maxRho);

  setwind(2);
    graphset;
    _paxes = 0; _pframe = 0;
    fonts("simplex simgrma");
    xtics(0,1.2,1.2,0);
    ytics(0,1.2,1.2,0);
    _pmsgstr = "\202r\201\000\202t\201\000A\000B\000C\000D\000Region atteignable avec\000les 8 familles de copule";
    _pmsgctl = 0.585~1.175~0.20~0~1~0~10 |
               1.165~0.585~0.20~0~1~0~10 |
               0.65~0.85~0.15~0~1~0~5 |
               0.65~0.45~0.15~0~1~0~5 |
               0.85~0.85~0.15~0~1~0~5 |
               0.40~0.25~0.15~0~1~0~5 |
               0.10~1~0.15~0~1~0~10 |
               0.10~0.95~0.15~0~1~0~10 ;
    _pmsgstr = _pmsgstr $+ "\000\202\39\201";
    _pmsgctl = _pmsgctl | 1.34~5.575~0.14~0~2~0~10 ;
    _psym =  0.66~0.825~11~4~0~1~0 |
             0.66~0.51~11~4~0~1~0 |
             0.86~0.825~11~4~0~1~0 |
             0.41~0.225~11~4~0~1~0 |
             0.30~0.92~8~2~0~1~0 ;
    _parrow = {0.85 0.10 0.775 0.14 5 .2 21 10 1 6 0};
    _parrow = 0.30~0.92~0.22~0.145~5~.2~21~0~1~6~3 ;
    draw;

    graphprt("-c=1 -cf=sklar21.eps");

  endwind;


