new;
library gdr,pgraph;
gdrSet;

x1 = seqa(-3,0.01,601); x2 = x1'; x3 = seqa(1/100,1/100,601);
u1 = seqa(0.01,0.01,99); u2 = u1';

tau = 0.5;

proc FindParameter(theta);
  retp((-KendallCopulaGumbel(theta) + tau)^2);
endp;

{theta,f0,g0,retcode} = Qnewton(&FindParameter,2);

pdf1 = pdfCopulaGumbel(u1,u2,theta);
pdf2 = pdfCopulaGumbel(cdfn(x1),cdfn(x2),theta) .* pdfn(x1) .* pdfn(x2);
pdf3 = pdfCopulaGumbel(cdfn(x1),cdft(x2,2),theta) .* pdfn(x1) .* pdft(x2,2);
pdf4 = pdfCopulaGumbel(cdfIG(x3,2,1.5),cdft(x2,5),theta) .* pdfIG(x3,2,1.5) .* pdft(x2,5);

graphset;
  begwind;
  window(2,2,0);
  _pnum = 2; 
  _paxht = 0.25; _pnumht = 0.20;
  fonts("simplex simgrma");

  setwind(1);
    _plev = seqa(0.5,0.25,10); xtics(0,1,0.2,2); ytics(0,1,0.2,2);    
    xlabel("\216u]1["); ylabel("\216u]2["); _pzclr = 0|0;
    contour(u1',u2',pdf1');

    _plev = seqa(0.01,0.02,10);  xtics(-3,3,1,2); ytics(-3,3,1,2);

  setwind(2);
    xlabel("\216N(0,1)"); ylabel("\216N(0,1)"); 
    contour(x1',x2',pdf2');

  setwind(3);
    xlabel("\216N(0,1)"); ylabel("\216t]2["); 
    contour(x1',x2',pdf3');

  setwind(4);
    xlabel("\216IG(2,1.5)"); ylabel("\216t]5["); 
    xtics(0,5,1,2);
    contour(x3',x2',pdf4');

    graphprt("-c=1 -cf=sklar20.eps");

  endwind;