new;
library gdr,pgraph;
gdrSet;

_intord = 24;

declare matrix rho;
rhoVector = seqa(-1,0.005,401);

proc cdfCopula(u1,u2);
  retp( cdfCopulaNormal2(u1,u2,rho) );
endp;

tau = zeros(rows(rhoVector),1); varrho = tau; sigma = tau; PhiSqr = tau;

i = 1;
do until i > rows(rhoVector);
  rho = rhoVector[i];
  tau[i] = KendallCopula(&cdfCopula);
  varrho[i] = SpearmanCopula(&cdfCopula);
  sigma[i] = sigmaCopula(&cdfCopula);
  PhiSqr[i] = PhiSqrCopula(&cdfCopula);
  i = i + 1;
endo;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(2,2,0.5,1,1);
  _pdate = ""; _pnum = 2; _pcross = 1; _pframe = 0; _plwidth = 10; _pltype = 6|3; _pcolor = 1|5;
  xtics(-1,1,0.5,2); ytics(0,1,0.25,2);
  fonts("simplex simgrma");
  xlabel("\216\202t\201");
  _plegstr = "\202s\201\000\202F\201[2]"; _plegctl = {2 7 7 4.5};

  setwind(1);
    xy(tau,sigma~PhiSqr);
    _plegctl = 0; _paxht = 0.40; _pnumht = 0.30;

  setwind(2);
    _paxht = 0.40;
    xlabel("\216\202r\201");
    xy(rhoVector,sigma~PhiSqr);

    graphprt("-c=1 -cf=sklar16.eps");

  endwind;
