new;
library gdr,pgraph;
gdrSet;

x1 = seqa(1/100,4/100,101);
x2 = 0.001~seqa(0.01,0.99/100,99)'~0.999;

u1 = seqa(0.01,0.01,99); u2 = u1';

tau = 0.5; rho = sin(pi/2*tau);

mu = 2; lambda = 1.5; /* Parameters of the IG distribution */
a = 2; b = 2;         /* Parameters of the Beta distribution */  

pdf1 = pdfIG(x1,mu,lambda);
cdf1 = cdfIG(x1,mu,lambda);

pdf2 = pdfBeta(x2,a,b);
cdf2 = cdfBeta(x2,a,b);

pdf3 = pdfCopulaNormal2(u1,u2,rho);
pdf4 = pdfCopulaNormal2(cdf1,cdf2,rho) .* pdf1 .* pdf2;

graphset;
  begwind;
  window(2,2,0);
  _pnum = 2; 
  _paxht = 0.25; _pnumht = 0.20; _pframe = 0;
  _ptitlht = 0.25; _plwidth = 10; _pcolor = 2;

  fonts("simplex simgrma");

  setwind(1);
    title("\216F]1[ = IG(2,1.5)");
    xlabel("\216x]1[");
    xtics(0,4,1,2);
    ytics(0,0.6,0.2,2);
    xy(x1,pdf1);

  setwind(2);
    title("\216F]2[ = B(2,2)");
    xlabel("\216x]2[");
    xtics(0,1,0.25,2);
    ytics(0,1.5,0.5,2);
    xy(x2',pdf2');

    _paxht = 0.30;

  setwind(3);
    title("\216Densite de la copule C");
    _pmsgstr = "\202\39\201";
    _pmsgctl = 3.758~6.218~0.20~0~2~0~6;
    xtics(0,1,0.2,2);
    ytics(0,1,0.2,2);    
    xlabel("\215u]1[");
    ylabel("\215u]2[");
    _pzclr = { 0.25  5, 
               0.5   1,
               1.25  2,
               5   0,
               10 3,
               15 4};
    surface(u1',u2',pdf3');

  setwind(4);
    title("\216Densite de C(F]1[(x]1[),F]2[(x]2[))");
    _pmsgstr = "\202\39\201";
    _pmsgctl = 3.38~6.217~0.20~0~2~0~6;
    xtics(0,1,0.2,2);
    ytics(0,4,1,2);    
    ztics(0,1.5,0.5,2);    
    _pzclr = {  12 };
   _pzclr = { 0.02  5, 
              0.05   1,
              0.25  2,
              0.45   0,
              0.75 3,
              1.00 4,
              1.25 1,
              2.00 2};
    xlabel("\215x]2[");
    ylabel("\215x]1[");
    _pview = 1|4|3|3;
    surface(x2,x1,pdf4);

    graphprt("-c=1 -cf=sklar1.eps");

  endwind;
