new;
library gdr,pgraph;
gdrset;

mu1 = 1;
mu2 = 2;
sigma1 = 2;
sigma2 = 1;

proc cdf(x,mu,sigma);
  x = (x - mu) ./ sigma;
  retp( cdfn(x) );
endp;

proc invcdf(x,mu,sigma);
  x = missex(x, x.<0 .or x.> 1);
  retp( mu + sigma .* cdfni(x) );
endp;

fn cdf1(x) = cdf(x,mu1,sigma1);
fn cdf2(x) = cdf(x,mu2,sigma2);
fn invcdf1(x) = invcdf(x,mu1,sigma1);
fn invcdf2(x) = invcdf(x,mu2,sigma2);

u = unique(seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|0.7|seqa(0.951,0.001,40),1);
{ldb1,udb1} = DependencyBounds1(&invcdf1,&invcdf2,u,u);
u = 0|u|1;
ldb1 = -10|ldb1|20;
udb1 = -10|udb1|20;

alpha = 0.7;
indx = sumc(u .<= alpha);
xstar = ldb1[indx];

p1 = 1~3~-10~alpha~20~alpha~1~0~6 | 
     1~3~xstar~-1~xstar~1~1~0~6 ;

ustar = alpha;

c2 = 1~6~0~0~ustar~ustar~1~5~10 | 
     1~1~ustar~1~1~ustar~1~1~10 ;

p2 = 1~3~0~ustar~1~ustar~1~0~6 | 
     1~3~ustar~0~ustar~1~1~0~6 ;

p3 = 1~3~-10~invcdf2(ustar)~10~invcdf2(ustar)~1~0~6 | 
     1~3~invcdf1(ustar)~-10~invcdf1(ustar)~10~1~0~6 ;

x = seqa(0,ustar/200,201) ;
y = seqa(0,ustar/200,201) ;
N1 = invcdf1(x)~invcdf2(y);

x =  seqa(ustar,(1-ustar)/200,201);
y =  ustar + 1-seqa(ustar,(1-ustar)/200,201);
N2 = invcdf1(x)~invcdf2(y);


graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,0);
  makewind(9/2,6.855/2,0,0,0);
  makewind(9/2,6.855/2,9/2,0,0);

  setwind(1);

    _pnum = 2; _pframe = 0; _pdate = ""; _paxht = 0.25; _ptitlht = 0.30; _pcolor = 0|0;
    _pnumht = 0.20;
    fonts("simplex simgrma");
    xtics(-5,12.5,2.5,2);
    ytics(0,1,0.2,2);
    _plwidth = 10;
    ylabel("\216F]1+2[(x)"); xlabel("\216x");
    _pline = p1;
    _pmsgstr = "x[*]\000\202a\201 = G]v[(x[*])";
    _pmsgctl = xstar+0.25~0.025~0.35~0~1~5~6 |
               -4.9~alpha+0.025~0.35~0~1~5~6;
    xy(ldb1~udb1,u);
    
  setwind(2);

    title("\216C]v[(u]1[,u]2[)");
    xtics(0,1,0.2,2);
    ytics(0,1,0.2,2);
    xlabel("\216u]1[");
    ylabel("\216u]2[");
    _pline = c2 | p2;
    _pmsgstr = "\202a\201\000\202a\201";
    _pmsgctl = ustar-0.01~-0.075~0.35~0~1~5~6 |
               -0.05~ustar-0.01~0.35~0~1~5~6;
    draw;  

  setwind(3);
    title("\216F]v[(x]1[,x]2[) = C]v[(F]1[(x]1[),F]2[(x]2[))");
    _pcolor = 5|1;
    xtics(-2,6,2,2);
    ytics(0,6,2,2);
    xlabel("\216N(1,2)");
    ylabel("\216N(2,1)");
    _pline =  p3; 
    _pmsgstr = "F]1[[-1](\202a\201)\000F]2[[-1](\202a\201)";
    _pmsgctl = invcdf1(ustar)+0.05~-1.8+2~0.25~0~1~5~6 |
               -1.8~invcdf2(ustar)+0.20~0.25~0~1~5~6;

    xy(N1[.,1]~N2[.,1],N1[.,2]~N2[.,2]);

    graphprt("-c=1 -cf=agreg9.eps");
  endwind;
