new;
library gdr,pgraph;
gdrset;

declare matrix cdftype = 1;
declare matrix df = 2;

proc cdf(x);
  if cdftype == 1;
    retp( cdfn(x) );
  else;
    retp( cdft(x,df) );  
  endif;
endp;

proc invcdf(x);
  x = missex(x, x.<0 .or x.> 1);
  if cdftype == 1;
    retp( cdfni(x) );
  else;
    retp( cdftci(1-x,df) );  
  endif;
endp;

fn cdf1(x) = cdf(x);
fn cdf2(x) = cdf(x);
fn invcdf1(x) = invcdf(x);
fn invcdf2(x) = invcdf(x);

u = unique(seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|seqa(0.951,0.001,40),1);
cdftype = 1;
{ldb,udb} = DependencyBounds1(&invcdf1,&invcdf2,u,u);
ldb = trimr(ldb,1,1);
udb = trimr(udb,1,1);
db1 = (-20|ldb|20) ~ (-20|udb|20);

cdftype = 2; df = 2;
{ldb,udb} = DependencyBounds1(&invcdf1,&invcdf2,u,u);
ldb = trimr(ldb,1,1);
udb = trimr(udb,1,1);
db2 = (-20|ldb|20) ~ (-20|udb|20);

u = trimr(u,1,1);
u = 0|u|1;

indx = 1|seqa(5,5,10)|seqa(50,1,182)|seqa(235,5,8)|rows(u);

graphset;
  _pnum = 2; _pframe = 0; _pdate = "";
  _pltype = 6|6|3|3; _pcolor = 1|1|12|12;
  _plwidth = 10;
  ylabel("\216F]1+2[(x)"); xlabel("\216x");
  ytics(0,1,0.2,2);
  xtics(-10,10,5,2);
  e = ones(rows(u),1);
  _pline = submat((1~6).*e~db1[.,1]~u~db1[.,2]~u~e.*(1~0~0),indx,0);
  graphprt("-c=1 -cf=agreg8.eps");
  xy(db1~db2,u);


