new;
library gdr,pgraph;
gdrset;

mu1 = 1;
mu2 = 2;
sigma1 = 2;
sigma2 = 1;

proc cdf(x,mu,sigma);
  x = (x - mu) ./ sigma;
  retp( cdfn(x) );
endp;

proc invcdf(x,mu,sigma);
  x = missex(x, x.<0 .or x.> 1);
  retp( mu + sigma .* cdfni(x) );
endp;

fn cdf1(x) = cdf(x,mu1,sigma1);
fn cdf2(x) = cdf(x,mu2,sigma2);
fn invcdf1(x) = invcdf(x,mu1,sigma1);
fn invcdf2(x) = invcdf(x,mu2,sigma2);

u = unique(seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|seqa(0.951,0.001,40),1);
{ldb1,udb1} = DependencyBounds1(&invcdf1,&invcdf2,u,u);
{ldb2,udb2} = DependencyBounds2(&invcdf1,&invcdf2,u,u);
u = 0|u|1;
ldb1 = -10|ldb1|20;
udb1 = -10|udb1|20;
ldb2 = -10|ldb2|20;
udb2 = -10|udb2|20;

rho = -1~0~1;

mu = mu1 + mu2;
sigma = sqrt(sigma1^2 + 2*rho*sigma1*sigma2 + sigma2^2);
invG = invcdf(u,mu,sigma);
indx = 1|seqa(5,5,10)|seqa(50,1,182)|seqa(235,5,8)|rows(u);

e = ones(rows(u),1);

graphset;
  _pnum = 2; _pframe = 0; _pdate = "";
  xtics(-5,12.5,2.5,2);
  ytics(0,1,0.2,2);
  _pltype = 1|1|6|6; _pcolor = 12|12|1|1;
  _plwidth = 10;
  _pline = submat((1~6).*e~ldb2~u~udb2~u~e.*(1~0~0),indx,0);  
  ylabel("\216F]1+2[(x)"); xlabel("\216x");
  graphprt("-c=1 -cf=agreg7.eps");
  xy(ldb1~udb1~ldb2~udb2,u);

