new;
library gdr,pgraph;
gdrset;

mu1 = 1;
mu2 = 2;
sigma1 = 2;
sigma2 = 1;

proc cdf(x,mu,sigma);
  x = (x - mu) ./ sigma;
  retp( cdfn(x) );
endp;

proc invcdf(x,mu,sigma);
  x = missex(x, x.<0 .or x.> 1);
  retp( mu + sigma .* cdfni(x) );
endp;

fn cdf1(x) = cdf(x,mu1,sigma1);
fn cdf2(x) = cdf(x,mu2,sigma2);
fn invcdf1(x) = invcdf(x,mu1,sigma1);
fn invcdf2(x) = invcdf(x,mu2,sigma2);

u = unique(seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|seqa(0.951,0.001,40),1);
{ldb1,udb1} = DependencyBounds1(&invcdf1,&invcdf2,u,u);
u = 0|u|1;
ldb1 = -10|ldb1|20;
udb1 = -10|udb1|20;

rho = -1~0~1;

mu = mu1 + mu2;
sigma = sqrt(sigma1^2 + 2*rho*sigma1*sigma2 + sigma2^2);
invG = invcdf(u,mu,sigma);
indx = 1|seqa(5,5,10)|seqa(50,1,182)|seqa(235,5,8)|rows(u);

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  setwind(1);
    _pnum = 2; _pframe = 0; _pdate = "";
    fonts("simplex simgrma");
    xtics(-5,12.5,2.5,2);
    ytics(0,1,0.2,2);
    _pltype = 1|1|6|6|6; _pstype = 1|1|8|9|10;
    _plwidth = 10; _plctrl = 0|0|25|25|25; _pcolor = 2|3|4|5|1;
    e = ones(rows(u),1);
    _pline = submat((1~6).*e~ldb1~u~udb1~u~e.*(1~0~0),indx,0);
    ylabel("\216F]1+2[(x)"); xlabel("\216x");
    _plegstr = "Borne inferieure\000Borne superieure\000C[-]\000C[\202\74\201]\000C[+]";
    _plegctl = {2 5 6 1.5};
    xy(ldb1~udb1~invG,u);

  setwind(2);
    _pnum = 0; _paxes = 0;
    title("");
    xlabel(""); ylabel("");
    _plegctl = 0; _pline = 0; 
    _pmsgstr = "\202\39\201\000\202\39\201";
    _pmsgctl = 7.765~2.75~0.14~0~2~0~0 |
               7.86~2.483~0.14~0~2~0~0 ;
    draw;

    graphprt("-c=1 -cf=agreg6.eps");

  endwind;
