new;
library gdr,pgraph;
gdrSet;

declare matrix _order_i,_order_n,_order_theta;

t = seqa(0.001,1/10,151);
fn F(x) = cdfLN(x,0,1);

proc cdfCopula(u);
  retp( (sumc(u'^(-_order_theta)) - cols(u) + 1)^(-1/_order_theta) );
endp;

proc pdfOrderStatistic2(theta,t,i,n);
  local pdf,j;

  pdf = zeros(rows(t),rows(theta));
  _order_i = i;
  _order_n = n;

  j = 1;
  do until j > rows(theta);
    _order_theta = theta[j];
    pdf[.,j] = gradp1D(&__pdfOrderStatistic2,t);
    j = j + 1;
  endo;

  retp(pdf);
endp;

proc __pdfOrderStatistic2(t);
  retp( cdfOrderStatistic2(&cdfCopula,&F .* ones(_order_n,1),t,_order_i) );
endp;


theta = 0.5|1|2;
pdf1 = pdfOrderStatistic2(theta,t,10,10);
pdf2 = pdfOrderStatistic2(theta,t,6,10);
theta = 0.5;
pdf3 = pdfOrderStatistic2(theta,t,3,4) ~ pdfOrderStatistic2(theta,t,3,8) ~ 
       pdfOrderStatistic2(theta,t,3,12);
theta = 2;
pdf4 = pdfOrderStatistic2(theta,t,3,4) ~ pdfOrderStatistic2(theta,t,3,8) ~ 
       pdfOrderStatistic2(theta,t,3,12);

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3; _plwidth = 10; 
  _paxht = 0.20; _pnumht = 0.20; _ptitlht = 0.25;

  fonts("simplex simgrma");

  xlabel("\214t");
  ylabel("\214f]i:n[(t)");
  xtics(0,10,2.5,5);

  setwind(1);
    ytics(0,0.25,0.05,2);
    title("\214i = 10 - n = 10");
    _plegstr = "\202Q\201 = 0.5\000\202Q\201 = 1\000\202Q\201 = 2";
    _plegctl = {2 5 6.5 4};
    xy(t,pdf1);

  setwind(2);
    ytics(0,0.7,0.1,2);
    title("\214i = 6 - n = 10");
    _plegstr = "\202Q\201 = 0.5\000\202Q\201 = 1\000\202Q\201 = 2";
    _plegctl = {2 5 6.5 4};
    xy(t,pdf2);

  setwind(3);
    ytics(0,1.25,0.25,2);
    title("\214\202Q\201 = 0.5 - i = 3");
    _plegstr = "n = 4\000n = 8\000n = 12";
    _plegctl = {2 5 6.5 4};
    xy(t,pdf3);

  setwind(4);
    ytics(0,0.9,0.2,2);
    title("\214\202Q\201 = 2 - i = 3");
    _plegstr = "n = 4\000n = 8\000n = 12";
    _plegctl = {2 5 6.5 4};
    xy(t,pdf4);

    graphprt("-c=1 -cf=agreg44.eps");

  endwind;
