new;
library gdr,pgraph;
gdrSet;

cls;

format 5,3;

ratings = "AAA" | "BBB"| "B" | "CCC";
let recovery = 0.90 0.70 0.40 0.20;
let rates[7,1] = 3.60 3.65 3.72 4.10 5.55 6.05 15.05;
rates = rates / 100;
P0 = 100 ./ 1.036 + 100 ./ 1.041 + 100 ./ 1.065 + 100 ./ 1.1505;

year = 1;
SetTransitionMatrix(1);
TM = ComputePdfMigration(0,0,year,0); 
SetTransitionMatrix(TM);

let rho = 1.00 
           0.25 1.00
           0.75 0.50 1.00
           0.50 0.25 0.75 1.00
           0.25 0.25 0.25 0.25 1.00
           0.20 0.10 0.20 0.50 0.50 1.00;

rho = xpnd(rho);

Ns = 5000;
Np = 10;
r = zeros(Ns,4);

i = 1;
do until i > Ns;
  r[i,.] = RatingMapping(submat(SimulateRatingProcess(ratings,rho,Np),Np,0),0);
  i = i + 1;
endo;

r = r';

P = 0;
i = 1;
do until i > 8;
  e = r .== i;
  if i == 1;
    P = P + sumc(100 .* e .* recovery);
  else;
    P = P + sumc(100 .* e ./ (1+rates[9-i]));
  endif;
  i = i + 1;
endo;

loss = P - P0;

VaR = quantile(loss,0.01|0.10);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  xlabel("\214Loss"); ylabel("\214Frequency");
  _pline = 1~6~VaR[1]~0~VaR[1]~100~1~12~10 |
           1~6~VaR[2]~0~VaR[2]~100~1~10~10 ;
  graphprt("-c=1 -cf=agreg41.eps");
  call histp(loss,50);

