new;
library gdr,pgraph;
gdrSet;

dataset = "lme";
let vars  = AL AL-15 CU NI PB;

data = LoadData(dataset,vars);
dates = LoadData(dataset,"date");

let theta[3,5] =     1 1 1 1 1
                    -1 -1 -1 1 1
                     2 1 -3 4 -5;
theta = theta';
let alpha = 0.90 0.95 0.99 0.995 0.999;
let P = 100 100 100 100 100;
ns = 300000;
nu = 1;

data = ln(data);
r = packr(data - lag1(data));
mu = meanc(r); 
sigma = stdc(r);

u = dependogram(r);
{rhoStudent,rhoNormal} = regCopulaStudent(substute(u,u.==1,1-__macheps),nu);

format 8,4;

output file = agreg4.out reset;

/*
**> Normal copula + Gaussian distributions
**
*/

rndseed 123;

u = rndCopulaNormal(rhoNormal,ns);
r = mu' + cdfni(u) .* sigma';
thetaStar = theta .* P;
VaR = zeros(rows(alpha),cols(thetaStar));
i = 1;
do until i > cols(VaR);
  VaR[.,i] = - _rndCopulaEmpiricalQuantile(r*thetaStar[.,i],1-alpha);
  i = i + 1;
endo;

print VaR';
clear u,r;

/*
**> Student copula + Gaussian distributions
**
*/

rndseed 123;

u = rndCopulaStudent(rhoStudent,nu,ns);
r = mu' + cdfni(u) .* sigma';
i = 1;
do until i > cols(VaR);
  VaR[.,i] = - _rndCopulaEmpiricalQuantile(r*thetaStar[.,i],1-alpha);
  i = i + 1;
endo;

print VaR';
clear u,r;

/*
**> Normal copula + Student distributions
**
*/

rndseed 123;

df = 4;
sigma = sigma/sqrt(df/(df-2));

u = rndCopulaNormal(rhoNormal,ns);
r = mu' + cdfti(u,df) .* sigma';
thetaStar = theta .* P;
VaR = zeros(rows(alpha),cols(thetaStar));
i = 1;
do until i > cols(VaR);
  VaR[.,i] = - _rndCopulaEmpiricalQuantile(r*thetaStar[.,i],1-alpha);
  i = i + 1;
endo;

print VaR';
clear u,r;

output off;