new;
library gdr,pgraph;
gdrSet;

cls;

rndseed 123123;

format 5,3;

ratings = "AAA" | "BBB"| "B" | "CCC";

year = 1;
SetTransitionMatrix(1);
TM = ComputePdfMigration(0,0,year,0); 
SetTransitionMatrix(TM);

let rho2 = 1.00 
           -0.25 1.00
           -0.75 0.50 1.00
           -0.50 0.25 0.75 1.00;

rho2 = xpnd(rho2);

Ns = 5;
Np = 30;
rating_1 = zeros(Np+1,Ns);
rating_2 = zeros(Np+1,Ns);
rating_3 = zeros(Np+1,Ns);
rating_4 = zeros(Np+1,Ns);

rndCopulaSobol(0);

i = 1;
do until i > Ns;
  r = SimulateRatingProcess(ratings,rho2,Np);
  rating_1[.,i] = RatingMapping(ratings[1]|r[.,1],0);
  rating_2[.,i] = RatingMapping(ratings[2]|r[.,2],0);
  rating_3[.,i] = RatingMapping(ratings[3]|r[.,3],0);
  rating_4[.,i] = RatingMapping(ratings[4]|r[.,4],0);
  i = i + 1;
endo;

t = seqa(0,1,Np+1);

graphset;
  begwind;
  window(2,2,0);

  margin(0.75,0,0,0);  
  _pframe = 0; _pnum = 2; _pnumht = 0.25; _paxht = 0.30; _pcolor = seqa(0,1,9);
  xlabel("\216t");
  xtics(0,30,10,2);
  ytics(0,9,1,0);
  _plwidth = 10; _pltype = 3; _plctrl = 4; _pstype = 8|9|10|11|12; _psymsiz = 8;
  let lab[10,1] = "" "D" "CCC" "B" "BB" "BBB" "A" "AA" "AAA" "";
  asclabel(0,lab); 

  setwind(1);
    xy(t,rating_1);

  setwind(2);
    xy(t,rating_2);

  setwind(3);
    xy(t,rating_3);

  setwind(4);
    xy(t,rating_4);

  graphprt("-c=1 -cf=agreg38.eps");

  endwind;   