new;
library gdr,pgraph;
gdrSet;

declare matrix rho;

proc RhoMatrix(rho);
  retp( diagrv(ones(4,4)*rho,ones(4,1)) );
endp;

rating = ("BB" | "CCC" | "B" | "CCC") ~
         ("BB" | "BBB" | "B" | "CCC") ~
         ("BB" | "BB" | "BB" | "BB") ~
         ("B" | "B" | "B" | "B") ~
         ("CCC" | "A" | "CCC" | "CCC") ;
indx = 9-RatingMapping(rating,0);
year = 5;

SetTransitionMatrix(1);
TM = ComputePdfMigration(0,0,year,0); 
SetTransitionMatrix(TM);

rho = seqa(0,1/100,92); 
p = zeros(rows(rho),cols(rating));

j = 1;
do until j > cols(rating);
  pD = TM[indx[.,j],8];
  i = 1;
  do until i > rows(rho);
    p[i,j] = cdfCopulaNormal(pD',RhoMatrix(rho[i]));
    i = i + 1;
  endo;
  j = j + 1;
endo;

graphset;
  _pdate = "";
  fonts("simplex simgrma");
  _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|6|6; _pstype = 8|8|8|8|9; _plwidth = 10; _pcolor = 2|1|4|5|0;
  _plctrl = 0|0|0|10|10;
  ytics(0,12.5,2.5,2);
  xtics(0,0.9,0.1,2);
  _plegstr = "Portefeuille I\000Portefeuille II\000Portefeuille III\000"\
             "Portefeuille IV\000Portefeuille V";
  _plegctl = {2 5 2 4.75};
  xlabel("\216\202r\201");
  graphprt("-c=1 -cf=agreg32.eps");
  xy(rho,100*P);
