new;
library gdr,pgraph;
gdrSet;

declare matrix rho,theta;

fn cdfCopula1(u1,u2) =cdfCopulaNormal2(u1,u2,rho);

proc cdfCopula2(u1,u2);
  u1 = substute(u1,u1 .== 0, __macheps);
  u2 = substute(u2,u2 .== 0, __macheps);
  retp( cdfCopulaGumbel(u1,u2,theta) );
endp;

proc cdfCopula3(u1,u2);
  u1 = substute(u1,u1 .== 0, __macheps);
  u2 = substute(u2,u2 .== 0, __macheps);
  retp( u1 + u2 - 1 + cdfCopulaGumbel(1-u1,1-u2,theta) );
endp;

rating1 = "A" | "A" | "BB" | "CCC";
rating2 = "AA" | "BB" | "B" | "CCC";
indx1 = 9-RatingMapping(rating1,0);
indx2 = 9-RatingMapping(rating2,0);
year = 5;

SetTransitionMatrix(1);
TM = ComputePdfMigration(0,0,year,0); 
SetTransitionMatrix(TM);
 
tauKendall = seqa(0,1/201,200);
rho = sin(pi/2*tauKendall);
theta = 1/(1-tauKendall);
p12a = zeros(200,4);
p12b = zeros(200,4);
p12c = zeros(200,4);

i = 1;
do until i > 4;
  p1 = TM[indx1[i],8];
  p2 = TM[indx2[i],8];
  p12a[.,i] = cdfCopula1(p1,p2);
  p12b[.,i] = cdfCopula2(p1,p2);
  p12c[.,i] = cdfCopula3(p1,p2);
  i = i + 1;
endo;

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pnumht = 0.20; _paxht = 0.25; _ptitlht = 0.25;
  _pltype = 6|1|3; _pcolor = 2|4|1; _plwidth = 10;
 
  fonts("simplex simgrma");
  xlabel("\216\202t\201");
  xtics(0,1,0.25,2);
  ytics(0,0.20,0.05,0); 

  i = 1;
  do until i > 3;
    if i == 2; 
      ytics(0,0.60,0.20,2); 
    elseif i == 3;
      ytics(0,10,2,2); 
    endif;
    setwind(i);
      title("\216" $+ rating1[i] $+ " / " $+ rating2[i]);
      xy(tauKendall,100*(p12a[.,i]~p12b[.,i]~p12c[.,i]));
    i = i + 1;
  endo;

  setwind(i);
    title("\216" $+ rating1[i] $+ " / " $+ rating2[i]);
    ytics(0,80,20,2);
    _plegstr = "Normale\000Gumbel-Hougaard\000Survival Gumbel-Hougaard";
    _plegctl = {2 5 3.5 1.5};
    xy(tauKendall,100*(p12a[.,i]~p12b[.,i]~p12c[.,i]));

    graphprt("-c=1 -cf=agreg31.eps");

  endwind;

