new;
library gdr,pgraph;
gdrSet;

rho = -0.975~seqa(-0.95,0.05,39)'~0.975;
let alpha = 0.99;
VaR12 = zeros(2,cols(rho)+2);
e = ones(2,1);
ns = 100000;
rndseed 123;
{u1,u2} = rndCopulaUpper2(ns);
x1 = cdfti(u1,3); x2 = cdfni(u2);
VaR12[.,cols(rho)+2] = quantile(x1+x2,alpha)*e;
rndseed 123;
{u1,u2} = rndCopulalower2(ns);
x1 = cdfti(u1,3); x2 = cdfni(u2);
VaR12[.,1] = quantile(x1+x2,alpha)*e;

i = 1;
do until i > cols(rho);
  rndseed 123;
  {u1,u2} = rndCopulaNormal2(rho[i],ns);
  x1 = cdfti(u1,3); x2 = cdfni(u2);
  VaR12[1,i+1] = quantile(x1+x2,alpha);
  rndseed 123;
  {u1,u2} = rndCopulaStudent2(rho[i],1,ns);
  x1 = cdfti(u1,3); x2 = cdfni(u2);
  VaR12[2,i+1] = quantile(x1+x2,alpha);
  i = i + 1;
endo; 

rho = -1|rho'|1;
VaR12 = VaR12';

VaR12[1,.] = error(0) * e';
VaR12[rows(VaR12),.] = error(0) * e';

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0; _pltype = 6|3; _plwidth = 10; _pcolor = 12|1;
  fonts("simplex simgrma");
  xlabel("\216\202r\201");
  xtics(-1,1,0.25,2);
  _plegstr = "Copule Normale\000Copule Student t]1[";
  _plegctl = {2 6 1.75 5};
  graphprt("-c=1 -cf=agreg3.eps");
  xy(rho,VaR12);


