new;
library gdr,pgraph;
gdrSet;

let year = 1 5 10;
declare matrix corr1,corr2,corr3;

rating1 = "A" | "A" | "BB" | "CCC";
rating2 = "AA" | "BB" | "B" | "CCC";
indx1 = 9-RatingMapping(rating1,0);
indx2 = 9-RatingMapping(rating2,0);
rho = seqa(-1+1/100,1/100,199);

k = 1;
do until k > rows(year);
  SetTransitionMatrix(1);
  TM = ComputePdfMigration(0,0,year[k],0); 
  p = zeros(rows(rho),rows(rating1));
  pMin = zeros(rows(rating1),1);
  pMax = zeros(rows(rating1),1);
  p1 = zeros(1,rows(rating1));
  p2 = zeros(1,rows(rating1));

  i = 1;
  do until i > rows(rating1);
    j = 1;
    do until j > rows(rho);
      p[j,i] = ComputePdfMigration2(0,rating1[i],rating2[i],year[k],"D","D",rho[j]);
      p1[i] = TM[indx1[i],8];
      p2[i] = TM[indx2[i],8];
      pMin[i] = cdfCopulaLower2(p1[i],p2[i]);
      pMax[i] = cdfCopulaUpper2(p1[i],p2[i]);
      j = j + 1;
    endo;
  i = i + 1;
  endo;
  call varput(DiscreteDefaultCorrelation(pMin'|p|pMax',p1,p2),"corr" $+ ftos(k,"%lf",1,0));
  k = k + 1;
endo;

rho = -1 | rho | 1;

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pnumht = 0.20; _paxht = 0.25; _ptitlht = 0.30;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 2|4|1;
 
  fonts("simplex simgrma");
  xlabel("\216\202r\201");
  xtics(-1,1,0.5,2);
  ytics(-0.5,0.5,0.25,0); 

  i = 1;
  do until i > 3;
    setwind(i);
      title("\216" $+ rating1[i] $+ " / " $+ rating2[i]);
      xy(rho,corr1[.,i]~corr2[.,i]~corr3[.,i]);
    i = i + 1;
  endo;

  setwind(i);
    title("\216" $+ rating1[i] $+ " / " $+ rating2[i]);
    ytics(-1,1,0.5,0); 
    _plegstr = "1 an\0005 ans\00010 ans";
    _plegctl = {2 6 6.2 2};
    xy(rho,corr1[.,i]~corr2[.,i]~corr3[.,i]);

  graphprt("-c=1 -cf=agreg28.eps");

  endwind;

