new;
library gdr,pgraph;
gdrSet;

rating1 = "A" | "A" | "BB" | "CCC";
rating2 = "AA" | "BB" | "B" | "CCC";
indx1 = 9-RatingMapping(rating1,0);
indx2 = 9-RatingMapping(rating2,0);
year = 5;

SetTransitionMatrix(1);
TM = ComputePdfMigration(0,0,year,0); 
rho = seqa(-1+1/100,1/100,199);
p = zeros(rows(rho),rows(rating1));
pMin = zeros(rows(rating1),1);
pMax = zeros(rows(rating1),1);

i = 1;
do until i > rows(rating1);
  j = 1;
  do until j > rows(rho);
    p[j,i] = ComputePdfMigration2(0,rating1[i],rating2[i],year,"D","D",rho[j]);
    pi1 = TM[indx1[i],8];
    pi2 = TM[indx2[i],8];
    pMin[i] = cdfCopulaLower2(pi1,pi2);
    pMax[i] = cdfCopulaUpper2(pi1,pi2);
    j = j + 1;
  endo;
  i = i + 1;
endo;

rho = -1 | rho | 1;
p = pMin' | p | pMax';

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pnumht = 0.20; _paxht = 0.25; _ptitlht = 0.30;
  _plwidth = 10;
 
  fonts("simplex simgrma"); xlabel("\216\202r\201"); xtics(-1,1,0.5,2);

  i = 1;
  do until i > 4;
    setwind(i);
      title("\216" $+ rating1[i] $+ " / " $+ rating2[i]);
      _pline = 1~6~-1~100*pMin[i]~-0.8~100*pMin[i]~1~0~10 | 
               1~6~0.8~100*pMax[i]~1~100*pMax[i]~1~0~10 ;
      _pcolor = 4;
      if i == 1;
        ytics(0,0.20,0.05,0);
      elseif i == 2;
        ytics(0,0.6,0.2,0);
      elseif i == 3;
        ytics(0,10,2,0);
      elseif i == 4;
        ytics(0,60,20,0);
      endif;
      xy(rho,100*p[.,i]);
    i = i + 1;
  endo;

  graphprt("-c=1 -cf=agreg27.eps");

  endwind;

