new;
library gdr,pgraph;
gdrSet;

lambda1 = 10; mu1 = 1; sigma1 = 1;
lambda2 = 12; mu2 = 1.25; sigma2 = 0.5;

let alpha = 0.90 0.95 0.99 0.999;

Ns = 100000;
 
rho = -0.99|seqa(-0.95,0.05,39)|0.99;
CaR = zeros(rows(rho),rows(alpha));

i = 1;
do until i > rows(rho);
  rndseed 126;
  vartheta = rndLDA2(mu1,sigma1,lambda1,mu2,sigma2,lambda2,rho[i],ns);
  CaR[i,.] = quantile(vartheta[.,1]+vartheta[.,2],alpha)';
  i = i + 1;
endo;

rho2 = seqa(-1,0.01,200);
CaR2 = zeros(rows(rho2),rows(alpha));

i = 1;
do until i > rows(alpha);
  CaR2[.,i] = fspline(csspline(rho,CaR[.,i],1,0.5),rho2);
  i = i + 1;
endo;

graphset;
  _pcross = 1;
  _pdate = 0; _pnum = 2; _pframe = 0;
  _plwidth = 10; _pcolor = 9|10|11|12; _pstype = 8; _psymsiz = 4;
  _plctrl = 0|0|0|20; _pltype = 6|1|3|6; _pcolor = 1|2|4|5;
  fonts("simplex simgrma");
  xlabel("\216\202r\201");
  ylabel("\216CaR");
  xtics(-1,1,0.5,2);
  ytics(100,300,50,2);
  _plegstr = "\202a\201 = 90%\000\202a\201 = 95%\000\202a\201 = 99%\000\202a\201 = 99,9%";
  _plegctl = {2 5 1 5};
  graphprt("-c=1 -cf=agreg23.eps");
  xy(rho2,CaR2);

