new;
library gdr,pgraph;
gdrSet;

rndseed 126;

let alpha = 0.90 0.95 0.99 0.999;

lambda1 = 10; mu1 = 1; sigma1 = 1;
lambda2 = 12; mu2 = 1.25; sigma2 = 0.5;

ns = 100000;

rndseed 126;
vartheta = rndLDA2(mu1,sigma1,lambda1,mu2,sigma2,lambda2,0,ns);
vartheta1 = vartheta[.,1];
vartheta2 = vartheta[.,2];

_Kernel[1:2] = 0|200;
{x1,d1,f1,retcode} = Kernel(vartheta1);
_Kernel[1:2] = 0|150;
{x2,d2,f2,retcode} = Kernel(vartheta2);

_Kernel[1:2] = 0|300;
vartheta3 = vartheta1 + vartheta2;
{x3,d3,f3,retcode} = Kernel(vartheta3);

rho = -0.5;
{u1,u2} = rndCopulaNormal2(rho,ns);
vartheta = rndCopulaEmpiricalQuantile(u1~u2,vartheta1~vartheta2);
vartheta4 = vartheta[.,1] + vartheta[.,2];
{x4,d4,f4,retcode} = Kernel(vartheta4);

rho = 0.5;
{u1,u2} = rndCopulaNormal2(rho,ns);
vartheta = rndCopulaEmpiricalQuantile(u1~u2,vartheta1~vartheta2);
vartheta5 = vartheta[.,1] + vartheta[.,2];
{x5,d5,f5,retcode} = Kernel(vartheta5);

rho = 0.95;
{u1,u2} = rndCopulaNormal2(rho,ns);
vartheta = rndCopulaEmpiricalQuantile(u1~u2,vartheta1~vartheta2);
vartheta6 = vartheta[.,1] + vartheta[.,2];
{x6,d6,f6,retcode} = Kernel(vartheta6);

graphset;

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0; _plwidth = 10;

  xlabel("\216L");
  _pltype = 6|3|1|6; _pstype = 8; _plctrl = 0|0|0|20; _psymsiz = 2.5;
  _pcolor = 1|2|4|5;
  xtics(0,250,50,2);
  ytics(0,0.025,0.005,2);
  _plegstr = "\202r\201 = 0\000\202r\201 = -0,5\000\202r\201 = 0,5\000\202r\201 = 0,95";
  _plegctl = {2 5 6 4};
  graphprt("-c=1 -cf=agreg22.eps");
  xy(x3~x4~x5~x6,d3~d4~d5~d6);

