new;
library gdr,pgraph;
gdrset;

lambda1 = 10;
lambda2 = 12;
mu1 = 1; sigma1 = 1;
mu2 = 1.25; sigma2 = 0.5;

let rho = 0 -0.5 0.5 0.95;

Ns = 100000;
L = zeros(Ns,4);
_Kernel[1:3] = 0|250|256;
d = zeros(_Kernel[3],4);

iter = 1;
do until iter > 4;

 {N1,N2} = rndbvp(lambda1,lambda2,rho[iter],0,Ns);

  L1 = zeros(Ns,1);
  L2 = zeros(Ns,1);

  i = 1;
  do until i > Ns;

    if N1[i] > 0;
      L1[i] = sumc(rndLN(mu1,sigma1,N1[i],1));
    endif;

    if N2[i] > 0;
      L2[i] = sumc(rndLN(mu2,sigma2,N2[i],1));
    endif;

    i = i + 1;
  endo;

  L[.,iter] = L1 + L2;
  {x,d[.,iter],F,retcode} = Kernel(L[.,iter]);

  iter = iter + 1;
endo;

graphset;

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0; _plwidth = 10;

  xlabel("\216L");
  _pltype = 6|3|1|6; _pstype = 8; _plctrl = 0|0|0|20; _psymsiz = 2.5;
  _pcolor = 1|2|4|5;
  xtics(0,250,50,2);
  ytics(0,0.020,0.005,2);
  _plegstr = "\202r\201 = 0\000\202r\201 = -0,5\000\202r\201 = 0,5\000\202r\201 = 0,95";
  _plegctl = {2 5 6 4};
  graphprt("-c=1 -cf=agreg21.eps");
  xy(x,d);
