new;
library gdr,pgraph;
gdrset;

lambda1 = 30;
lambda2 = 60;

x1 = seqa(10,1,41);
x2 = seqa(30,1,61);

clear buffer;

rhoVector = -0.99|-0.5|0|0.5;

i = 1;
do until i > 4;
  rndseed 123;
  rho = rhoVector[i];
  {u1,u2} = rndbvp(lambda1,lambda2,rho,0,1000);

  N = zeros(41,61);
  j = 1;
  do until j > 61;
    N[.,j] = countwts(u1,x1,u2 .== x2[j]);
    j = j + 1;
  endo;

  buffer = vput(buffer,vec(N),ftos(i,"N%lf",1,0));  

  i = i + 1;
endo;

x = vec(x1 .* ones(1,61));
y = vec(ones(41,1) .* x2');


graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");
  _pnum = 2; _pnumht = 0.20; _paxht = 0.25; _ptitlht = 0.30;

  xtics(10,50,10,2);
  ytics(30,90,10,2);
  xlabel("\216N]1[");
  ylabel("\216N]2[");

  i = 1;
  do until i > 4;
    data = vread(buffer,ftos(i,"N%lf",1,0)); 
    data = delif(x~y~data,data .== 0);
    e = ones(rows(data),1); 
    setwind(i);
      str = ftos(rhoVector[i],"\216\202r\201 = %lf",3,2);
      str = strput(",",str,strindx(str,".",1));
      title(str); 
      _psym = data[.,1 2]~9*e~0.5*data[.,3]~e.*(1~1~4);
      draw;
    i = i + 1;
  endo;

  graphprt("-c=1 -cf=agreg20.eps");

  endwind;
