new;
library gdr,pgraph;
gdrSet;

declare matrix rho, nu;

alpha1 = 0.95;

alpha2 = 0.001|seqa(0.01,0.01,99)|0.991|0.992|0.993|0.994|0.995|0.999999;

fn CopulaN(u1,u2) = cdfCopulaNormal2(u1,u2,rho);

proc CopulaT(u1,u2);
  local cdf,i;
  cdf = zeros(rows(u2),rows(rho));
  i = 1;
  do until i > rows(rho);
    cdf[.,i] = cdfCopulaStudent2(u1,u2,rho[i],nu[i]);
    i = i + 1;
  endo;
  retp( cdf );
endp;

let rho = 0.20;
lambdaN = qqUpperCopula2(&CopulaN,alpha1,alpha2);

let rho = 0.20 0.0 -0.1 -0.60;
let nu = 4 4 1 1;
lambdaT = qqUpperCopula2(&CopulaT,alpha1,alpha2);

graphset;
  _pdate = "";
  _pcross = 1; _pframe = 0; _pnum = 2; _plwidth = 10;
  _pltype = 6|3|1|6|5; _pcolor = 2|1|5|0|4;
  _pstype = 8; _plctrl = 0|0|0|5|0; _psymsiz = 2.5;
  fonts("simplex simgrma");
  xtics(0,1,0.2,2);
  ytics(0,1,0.2,2);
  xlabel("\216\202a\201]2[");
  _plegstr = "Normale \202r\201 = 20%\000t]4[ \202r\201 = 20%"\
             "\000t]4[ \202r\201 = 0%\000t]1[ \202r\201 = -10%"\
             "\000t]1[ \202r\201 = -60%";
  _plegctl = {2 6 5 4.75};
  graphprt("-c=1 -cf=agreg18.eps");
  xy(alpha2,lambdaN~lambdaT);  