new;
library gdr,pgraph;
gdrset;

tau = 3/12;

sigma1 = 0.10;
sigma2 = 0.30;
b1 = 0.00;
b2 = 0.00;
r = 0.00;

S1 = 100; S2 = 95;

proc (1) = pdf2Proc(x1,x2,mu1,sigma1,mu2,sigma2,rho);
  local y1,y2,pdf;

  y1 = (ln(x1) - mu1)/sigma1;
  y2 = (ln(x2) - mu2)/sigma2;

  pdf = exp(-0.5 ./ (1-rho^2) .* (y1^2 + y2^2 - 2*rho.*y1.*y2)) ./
       (2*pi * sigma1 .* sigma2 .* sqrt(1-rho^2) .* x1 .* x2);  

  retp(pdf);
endp;

proc payoffProc(x,y);
  local Payoff1,Payoff2,Payoff3,Payoff4,payoff;

  payoff1 = x - 105;
  payoff2 = 95 - y;

  payoff1 = payoff1 .* (payoff1 .>= 0);	
  payoff2 = payoff2 .* (payoff2 .>= 0);	
  payoff = _max_(payoff1,payoff2) .* ( y .< 105);

  retp(PayOff);
endp;

declare matrix rho,M1,M2,V1,V2;

proc WorstOff(x,y);
  local pdf,payoff;

  payoff = payoffProc(x,y);
  pdf = pdf2Proc(x,y,M1,V1,M2,V2,rho);

  retp( missrv(pdf .* payoff,0));
endp;

rhoVector = -0.999|-0.99|-0.975|-0.95|-0.925|seqa(-0.9,0.1,19)|0.925|0.95|0.975|0.99;
nRho = rows(rhoVector);
let bounds = 250 10;

WO = zeros(nRho,4);

j = 1;
do until j > 4;
  if j == 1;
    tau = 3/12;
    sigma1 = 0.30;
    sigma2 = 0.20;
    S2 = 95;
  elseif j == 2;
    tau = 3/12;
    sigma1 = 0.30;
    sigma2 = 0.20;
    S2 = 105;
  elseif j == 3;
    tau = 1/12;
    sigma1 = 0.30;
    sigma2 = 0.20;
    S2 = 95;
  elseif j == 4;
    tau = 3/12;
    sigma1 = 0.10;
    sigma2 = 0.20;
    S2 = 95;
  endif;

  M1 = ln(S1) + (b1-0.5*sigma1^2)*tau;
  V1 = sigma1*sqrt(tau);

  M2 = ln(S2) + (b2-0.5*sigma2^2)*tau;
  V2 = sigma2*sqrt(tau);

  i = 1;
  do until i > nRho;
    rho = rhoVector[i];

    WO[i,j] = quadLegendre2(&WorstOff,bounds,bounds,512);

    i = i + 1;
  endo;

  j = j + 1;
endo;

graphset;
  begwind;
  window(2,2,0);
  _pltype = 6; _pcolor = 10; _pnum = 2; _pframe = 0;
  _pnumht = 0.20; _paxht = 0.25; _ptitlht = 0.30; _plwidth = 10; _pcolor = 4;
  fonts("simplex simgrma");
  xlabel("\216\202r\201");
  xtics(-1,1,.50,2);

  i = 1;
  setwind(i);
    title("\216S]2[ = 95   \202t\201 = 3M   \202s\201]1[ = 30%");
    ytics(5.0,6.5,0.5,2);
    xy(rhoVector,WO[.,i]);

  i = 2;
  setwind(i);
    title("\216S]2[ = 105   \202t\201 = 3M   \202s\201]1[ = 30%");
    ytics(1.0,4.0,1,2);
    xy(rhoVector,WO[.,i]);

  i = 3;
  setwind(i);
    title("\216S]2[ = 95   \202t\201 = 1M   \202s\201]1[ = 30%");
    ytics(2.5,3.5,0.5,2);
    xy(rhoVector,WO[.,i]);

  i = 4;
  setwind(i);
    title("\216S]2[ = 95   \202t\201 = 3M   \202s\201]1[ = 10%");
    ytics(3.76,4.01,0.05,2);
    xy(rhoVector,WO[.,i]);

   graphprt("-c=1 -cf=agreg16.eps");

  endwind;
