new;
library gdr,pgraph,optmum;
gdrset;

cls;

dataset = "lme";
let vars  = AL AL-15 CU NI PB;

data = ln(LoadData(dataset,vars));
r = data - lag1(data);

varphi = 44;               /* size of blocks (in trading days) */
T = 5|10|25|50|75|100;     /* Return time (in years)           */

x = seqa(0,0.0005,501);

uMax = zeros(rows(r)/varphi,cols(r));
uMin = zeros(rows(r)/varphi,cols(r));
thetaMax = zeros(3,cols(r));
thetaMin = zeros(3,cols(r));

__output = 0;
i = 1;
do until i > cols(r);

  rndseed 123;
  block = reshape(r[.,i],rows(r)/varphi,varphi)';
  Max = maxc(block); Min = -minc(block);
  {mu,sigma,xi} = regGEV(Max,0);
  thetaMax[.,i] = mu|sigma|xi;
  uMax[.,i] = cdfGEV(Max,mu,sigma,xi);

  {mu,sigma,xi} = regGEV(Min,0);
  thetaMin[.,i] = mu|sigma|xi;
  uMin[.,i] = cdfGEV(Min,mu,sigma,xi);

  i = i + 1;
endo;

T = 250*T / varphi;   /* Return time in trading days */
alpha = 1 - 1./T; 
stressMin = -100*cdfGEVi(alpha,thetaMin[1,.],thetaMin[2,.],thetaMin[3,.]);
stressMax = 100*cdfGEVi(alpha,thetaMax[1,.],thetaMax[2,.],thetaMax[3,.]);

proc computeTheta(theta);
  local goodtheta;
  goodtheta = zeros(2,1);
  goodtheta[1] = 1 + sqrt(theta[1]^2);
  goodtheta[2] = goodtheta[1] + sqrt(theta[2]^2);
  retp(goodtheta);
endp;

proc mlProc(theta);
  theta = computeTheta(theta);
  retp( -sumc(
              ln(pdfCopulaBDNRR(uMax[.,1],uMax[.,2],uMax[.,3],uMax[.,4],uMax[.,5],
              theta[1],theta[2]))
             ) );
endp;

sv = 0.5|1;
{theta,f,g,retcode} = optmum(&mlProc,sv);
thetaCopula = computeTheta(theta);

fn Copula1(u) = cdfCopulaBDNRR(u[1],u[2],u[3],u[4],u[5],thetaCopula[1],thetaCopula[2]);
fn Copula2(u) = prodc(u);
fn Copula3(u) = minc(u);

let StressScenario[3,5] = 0.05 0.05 0.05 0.05 0.05
                          0.02 0.03 0.03 0.01 0.10
                          0.0696 0.0579 0.0753 0.0846 0.1113;
StressScenario[3,.] = stressMax[1,.]/100;

ReturnTime = zeros(3,3);
_Copula_ = &Copula1 | &Copula2 | &Copula3;

i = 1;
do until i > rows(StressScenario);
  u = cdfGEV(StressScenario[i,.],thetaMax[1,.],thetaMax[2,.],thetaMax[3,.])';
  j = 1;
  do until j > rows(_Copula_); 
    ReturnTime[i,j] = varphi./(250*_SurvivorCopula(_Copula_[j],u));
    j = j + 1;
  endo;

  i = i + 1;
endo;

cls; format 15,10;

output file = agreg15.out reset;

print thetaMax;
print stressMax;

print thetaMin;
print stressMin;

print thetaCopula;
print returnTime;

output off;

