new;
library gdr,optmum,pgraph;
gdrSet;

rndseed 1234565;

cls;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

data = selif(data,data[.,1] .>= 19880101);

CAC40 = data[.,2];
DJ = data[.,3]; 
y = packr(CAC40~DJ~data[.,1]);
data = packr(LogReturn(y[.,1 2],1)~y[.,3]);
r = data[.,1 2];
extremes = data;

n = 22;       /* one month of trading */

year = 5;
rt = 250*year; 
alpha = 1 - n/rt;

__output = 0;

ShortStress = zeros(2,1);
LongStress = zeros(2,1);
theta_LongStress = zeros(3,2);
theta_ShortStress = zeros(3,2);
u_LongStress = zeros(rows(r)/n,2);
u_ShortStress = zeros(rows(r)/n,2);

i = 1;
do until i > 2;

  min = -OrderData(r[.,i],1,n);
  {mu,sigma,xi} = regGEV(min,0);
  theta_LongStress[1,i] = mu;
  theta_LongStress[2,i] = sigma;
  theta_LongStress[3,i] = xi;
  LongStress[i] = cdfGEVi(alpha,mu,sigma,xi);
  u_LongStress[.,i] = cdfGEV(min,mu,sigma,xi);

  max = OrderData(r[.,i],n,n);
  {mu,sigma,xi} = regGEV(max,0);
  theta_ShortStress[1,i] = mu;
  theta_ShortStress[2,i] = sigma;
  theta_ShortStress[3,i] = xi;
  ShortStress[i] = cdfGEVi(alpha,mu,sigma,xi);
  u_ShortStress[.,i] = cdfGEV(max,mu,sigma,xi);

  i = i + 1;
endo;

proc AlphaParametrization(theta,Family);
  local alpha;

  if Family == 1;                   /* Gumbel */
    alpha = 1 + sqrt(theta^2);  
  elseif Family == 2;               /* Galambos */
    alpha = sqrt(theta^2);  
  endif;

  retp(alpha);
endp;

Family = 1;                         /* Gumbel */
Parametrization = 1;

declare matrix u_IFM; 

proc procML(theta);
  local u1,u2,alpha,lnpdf;

  u1 = u_IFM[.,1];
  u2 = u_IFM[.,2];

  alpha = theta[1];

  if Parametrization;
    alpha = AlphaParametrization(theta,Family);
  else;
    alpha = theta;
  endif;

  if family == 1;                   /* Gumbel */
    lnpdf = ln(pdfCopulaGumbel(u1,u2,alpha));
  elseif family == 2;               /* Galambos */
    lnpdf = ln(pdfCopulaGalambos(u1,u2,alpha));
  endif;

  retp(lnpdf);
endp;

fn NegSumLL(theta) = -sumc(procML(theta));

data = u_ShortStress~u_LongStress;

let pairs[4,2] = 1 2
                 1 4
                 3 4
                 3 2;
let Portfolio[4,2] =  1  1
                      1 -1
                     -1 -1
                     -1  1;

theta = zeros(4,1);
__output = 0;
i = 1;
do until i > 4; 
  u_IFM = data[.,pairs[i,.]];
  sv = 0.5;
  {theta[i],fmin,grd,retcode} = optmum(&NegSumLL,sv);
  i = i + 1;
endo;

if Parametrization;
  alpha = AlphaParametrization(theta,Family);
else;
  alpha = theta;
endif;

output file = agreg14.out reset;

stress1 = -0.08;
stress2 = -0.08;
u1 = cdfGEV(-stress1,theta_LongStress[1,1],theta_LongStress[2,1],theta_LongStress[3,1]);
u2 = cdfGEV(-stress2,theta_LongStress[1,2],theta_LongStress[2,2],theta_LongStress[3,2]);
t1 = (n/250)./(1-u1);
t2 = (n/250)./(1-u2);
if Family == 1;
  t12 = (n/250)./(1-u1-u2+cdfCopulaGumbel(u1,u2,alpha[3]));
elseif Family == 2;
  t12 = (n/250)./(1-u1-u2+cdfCopulaGalambos(u1,u2,alpha[3]));
endif;
t12min = (n/250)./(1-u1-u2+cdfCopulaUpper2(u1,u2)); 
t12max = (n/250)./(1-u1-u2+cdfCopulaProduct2(u1,u2)); 
print t1~t2;
print t12min~t12~t12max;

output off;

np = 100;
stress1 = seqa(0,ShortStress[1]/(np-1),np)~seqa(0,ShortStress[1]/(np-1),np)~
          seqa(0,LongStress[1]/(np-1),np)~seqa(0,LongStress[1]/(np-1),np);
stress2 = seqa(0,ShortStress[2]/(np-1),np)~seqa(0,LongStress[2]/(np-1),np)~
          seqa(0,LongStress[2]/(np-1),np)~seqa(0,ShortStress[2]/(np-1),np);
BivariateStressIndependant1 = zeros(np,4);
BivariateStressIndependant2 = zeros(np,4);
BivariateStressCopula1 = zeros(np,4);
BivariateStressCopula2 = zeros(np,4);
u1 = zeros(np,4);
u2 = zeros(np,4);

_stress1_ = seqa(0,0.003,100);
_u1_ = zeros(rows(_stress1_),4);
pline_x = zeros(rows(_stress1_),4);
pline_y = zeros(rows(_stress1_),4);

i = 1;
do until i > 4;

  if Portfolio[i,1] == 1;
    u1[.,i] = cdfGEV(stress1[.,i],theta_ShortStress[1,1],theta_ShortStress[2,1],theta_ShortStress[3,1]);
    _u1_[.,i] = cdfGEV(_stress1_,theta_ShortStress[1,1],theta_ShortStress[2,1],theta_ShortStress[3,1]);
  else;
    u1[.,i] = cdfGEV(stress1[.,i],theta_LongStress[1,1],theta_LongStress[2,1],theta_LongStress[3,1]);
    _u1_[.,i] = cdfGEV(_stress1_,theta_LongStress[1,1],theta_LongStress[2,1],theta_LongStress[3,1]);
  endif;

  if Portfolio[i,2] == 1;
    u2[.,i] = cdfGEV(stress2[.,i],theta_ShortStress[1,2],theta_ShortStress[2,2],theta_ShortStress[3,2]);
  else;
    u2[.,i] = cdfGEV(stress2[.,i],theta_LongStress[1,2],theta_LongStress[2,2],theta_LongStress[3,2]);
  endif;

  t_tilde = (n/250)./(1-u1[.,i]-u2[.,i]'+cdfCopulaProduct2(miss(u1[.,i],0),miss(u2[.,i]',0)));
  indx = missrv(miss(sumc(t_tilde' .<= year),0),1);
  BivariateStressIndependant1[.,i] = stress1[.,i];
  BivariateStressIndependant2[.,i] = stress2[indx,i];

  if Family == 1;
    t_tilde = (n/250)./(1-u1[.,i]-u2[.,i]'+cdfCopulaGumbel(miss(u1[.,i],0),miss(u2[.,i]',0),alpha[i]));
  elseif Family == 2;
    t_tilde = (n/250)./(1-u1[.,i]-u2[.,i]'+cdfCopulaGalambos(miss(u1[.,i],0),miss(u2[.,i]',0),alpha[i]));
  endif;
  indx = missrv(miss(sumc(t_tilde' .<= year),0),1);
  BivariateStressCopula1[.,i] = stress1[.,i];
  BivariateStressCopula2[.,i] = stress2[indx,i];

  if Family == 1;
    t_tilde = (n/250)./(1-_u1_[.,i]-u2[.,i]'+cdfCopulaGumbel(miss(_u1_[.,i],0),miss(u2[.,i]',0),alpha[i]));
  elseif Family == 2;
    t_tilde = (n/250)./(1-_u1_[.,i]-u2[.,i]'+cdfCopulaGalambos(miss(_u1_[.,i],0),miss(u2[.,i]',0),alpha[i]));
  endif;
  indx = missrv(miss(sumc(t_tilde' .<= year),0),1);
  pline_x[.,i] = _stress1_;
  pline_y[.,i] = stress2[indx,i];


  i = i + 1;
endo;

ShortStress = 100 * ShortStress;
LongStress = -100 * LongStress;
BivariateStressIndependant1 = 100 * BivariateStressIndependant1 .* Portfolio[.,1]';
BivariateStressIndependant2 = 100 * BivariateStressIndependant2 .* Portfolio[.,2]';
BivariateStressCopula1 = 100 * BivariateStressCopula1 .* Portfolio[.,1]';
BivariateStressCopula2 = 100 * BivariateStressCopula2 .* Portfolio[.,2]';
pline_x = 100 * pline_x .* Portfolio[.,1]';
pline_y = 100 * pline_y .* Portfolio[.,2]';
e = ones(rows(pline_x),1);
end_pline = 15 * e; 
pline = e.*(1~6)~pline_x[.,1]~pline_y[.,1]~pline_x[.,1]~end_pline~e.*(1~0~0) |
        e.*(1~6)~pline_x[.,2]~pline_y[.,2]~pline_x[.,1]~-end_pline~e.*(1~0~0) |
        e.*(1~6)~pline_x[.,3]~pline_y[.,3]~pline_x[.,3]~-end_pline~e.*(1~0~0) |
        e.*(1~6)~pline_x[.,4]~pline_y[.,4]~pline_x[.,4]~end_pline~e.*(1~0~0) ;

sens = r .> 0;
u1 = abs(r[.,1]); 
u2 = abs(r[.,2]);
u1 = sens[.,1] .* cdfGEV(u1,theta_ShortStress[1,1],theta_ShortStress[2,1],theta_ShortStress[3,1]) + 
     (1-sens[.,1]) .* cdfGEV(u1,theta_LongStress[1,1],theta_LongStress[2,1],theta_LongStress[3,1]);
u2 = sens[.,2] .* cdfGEV(u2,theta_ShortStress[1,2],theta_ShortStress[2,2],theta_ShortStress[3,2]) +  
     (1-sens[.,2]) .* cdfGEV(u2,theta_LongStress[1,2],theta_LongStress[2,2],theta_LongStress[3,2]);
param = sens[.,1] + 10*sens[.,2];
param = recode(param,param .== (11~1~0~10),1|2|3|4); 
if Family == 1;
  t_tilde = (n/250)./(1-u1-u2+cdfCopulaGumbel(miss(u1,0),miss(u2,0),alpha[param]));
elseif Family == 2;
  t_tilde = (n/250)./(1-u1-u2+cdfCopulaGalambos(miss(u1,0),miss(u2,0),alpha[param]));
endif;
indx = indexcat((t_tilde .> year) .and (sens[.,1] .== sens[.,2]),1);
extremes = extremes[indx,.];
e = ones(rows(extremes),1);
xe = 100*extremes[.,1];
ye = 100*extremes[.,2];
de = date_2_string(extremes[.,3]);
indx = selif(seqa(1,1,rows(de)), trunc(extremes[.,3]/1e4) ./= 0 );
de[indx] = "" $+ ones(rows(indx),1);

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);
  fonts("simplex simgrma");

  setwind(1);
    _pcross = 1; _pdate = ""; _pframe = 0; _plwidth = 10;
    _pnum = 2; _pcolor = 1|1|1|1|4|4|4|4; _pltype = 3|3|3|3|1|1|1|1;
    xtics(-10,12,2,1);
    ytics(-10,12,2,1);
    
    xlabel("\216CAC 40");
    ylabel("\216Dow Jones");

    _pline = 1~6~LongStress[1]~LongStress[2]~LongStress[1]~ShortStress[2]~1~2~10 |
             1~6~LongStress[1]~ShortStress[2]~ShortStress[1]~ShortStress[2]~1~2~10 |
             1~6~ShortStress[1]~ShortStress[2]~ShortStress[1]~LongStress[2]~1~2~10 |
             1~6~ShortStress[1]~LongStress[2]~LongStress[1]~LongStress[2]~1~2~10 |
             pline;

    xy(BivariateStressIndependant1~BivariateStressCopula1,
       BivariateStressIndependant2~BivariateStressCopula2);

  setwind(2);
    _pline = 0;

    _pmsgstr = "C[+]\000C[\202\74\201]\000C";

    _pmsgctl = -7~5.7~0.20~0~1~2~10 |
                4.5~2.8~0.20~0~1~1~10 |
                5.7~-5.3~0.20~0~1~4~10 ; 

    _psym = (xe~ye)~e.*(4~5~0~1~10);
    _pmsgstr = _pmsgstr $+ "\000" $+ MakeMsgStr(de);
    _pmsgctl = _pmsgctl | (xe+0.5~ye-0.2)~e.*(0.14~0~1~0~10);
/*
    _pmsgctl[9,1 2] = xe[6]-1.5~ye[6]+0.5;
    _pmsgctl[11,1 2] = xe[8]+0.2~ye[8]-0.2;
    _pmsgctl[8,1 2] = xe[5]-1.5~ye[5]-1;
*/
    xy(BivariateStressIndependant1~BivariateStressCopula1,
       BivariateStressIndependant2~BivariateStressCopula2);

    graphprt("-c=1 -cf=agreg14.eps");

   
  endwind;

proc date_2_string(dates);
  local N,i,d,di,strng;

  N = rows(dates);
  d = " " $+ zeros(4,1);
  strng = " " $+ zeros(N,1);

  i = 1;
  do until i > N;
    di = ftos(dates[i],"%lf",8,0);
    d[1] = strsect(di,1,4);
    d[2] = strsect(di,5,2);
    d[3] = strsect(di,7,2);
    d = stof(0 $+ d)';
    strng[i] = datestr(d);
    i = i + 1;
  endo;

  retp(strng);
endp;
