new;
library gdr,pgraph,optmum;
gdrset;

cls;

dataset = "lme";
let vars  = AL AL-15 CU NI PB;

data = ln(LoadData(dataset,vars));
r = data - lag1(data);

varphi = 44;               /* size of blocks (in trading days) */
T = 5|10|25|50|75|100;     /* Return time (in years)           */

x = seqa(0,0.0005,501);

pdfMax = zeros(rows(x),cols(r));
pdfMin = zeros(rows(x),cols(r));
thetaMax = zeros(3,cols(r));
thetaMin = zeros(3,cols(r));

__output = 0;
i = 1;
do until i > cols(r);

  rndseed 123;
  block = reshape(r[.,i],rows(r)/varphi,varphi)';
  Max = maxc(block); Min = -minc(block);
  {mu,sigma,xi} = regGEV(Max,0);
  thetaMax[.,i] = mu|sigma|xi;
  pdfMax[.,i] = pdfGEV(x,mu,sigma,xi);

  {mu,sigma,xi} = regGEV(Min,0);
  thetaMin[.,i] = mu|sigma|xi;
  pdfMin[.,i] = pdfGEV(x,mu,sigma,xi);

  i = i + 1;
endo;

T = 250*T / varphi;   /* Return time in trading days */
alpha = 1 - 1./T; 
stressMin = -100*cdfGEVi(alpha,thetaMin[1,.],thetaMin[2,.],thetaMin[3,.]);
stressMax = 100*cdfGEVi(alpha,thetaMax[1,.],thetaMax[2,.],thetaMax[3,.]);

output file = agreg12.out reset;

format 8,4;
print thetaMin; print thetaMax;
print stressMin; print stressMax;

output off;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; 
  _pltype = 6|1|3|6|1; _pstype = 8|9|10|11|12; _plctrl = 25;
  _pxsci = 0; _plwidth = 10; _pframe = 0; _pcolor = 2|1|4|5|3;

  xtics(0,0.10,0.01,2); ytics(0,70,10,2);
  xlabel("\216-\202h\201[-]");

  _plegstr = "AL\000AL-15\000CU\000NI\000PB";
  _plegctl = {2 5 6 2};

  graphprt("-c=1 -cf=agreg12.eps");
  xy(x,pdfMin);

  xlabel("\216\202h\201[+]");
  graphprt("-c=1 -cf=agreg13.eps");
  xy(x,pdfMax);