new;
library gdr,pgraph;
gdrset;

cls;

declare matrix _bound_x;
declare matrix _lower_bound;

_rankindx = 2;

dataset = "lme";
let vars  = AL 
            AL-15
            CU 
            Ni 
            Pb;

__output = 0;

data = LoadData(dataset,vars);
data = packr(data - lag1(data));

cov = vcx(data);

mu = meanc(data);

let a1 = 5 3 0 0 0;
let a2 = 0 0 5 2 -3;

alpha = 0.99;

analyticVaR1 = cdfni(alpha)*sqrt(a1'*cov*a1) - a1'mu;
analyticVaR2 = cdfni(alpha)*sqrt(a2'*cov*a2) - a2'mu;

v1 = data*a1;
v2 = data*a2;

historicalVaR1 = quantile(v1,alpha);
historicalVaR2 = quantile(v2,alpha);

print "Portefeuile I";
print "Analytic / Historic";
print analyticVaR1~historicalVaR1;
print;

print "Portefeuile II";
print "Analytic / Historic";
print analyticVaR2~historicalVaR2;

proc pdf1(x);
  local m,sigma;

  m = a1'mu;
  sigma = sqrt(a1'*cov*a1);
  x = (x - m)/sigma;

  retp( pdfn(x)/sigma );
endp;

proc cdf1(x);
  local m,sigma;

  m = a1'mu;
  sigma = sqrt(a1'*cov*a1);
  x = (x - m)/sigma;

  retp( cdfn(x) );
endp;

proc invcdf1(x);
  local m,sigma;

  x = missex(x, x.<0 .or x.> 1);

  m = a1'mu;
  sigma = sqrt(a1'*cov*a1);

  retp(m + sigma *cdfni(x) );
endp;

proc pdf2(x);
  local m,sigma;

  m = a2'mu;
  sigma = sqrt(a2'*cov*a2);
  x = (x - m)/sigma;

  retp( pdfn(x)/sigma );
endp;

proc cdf2(x);
  local m,sigma;

  m = a2'mu;
  sigma = sqrt(a2'*cov*a2);
  x = (x - m)/sigma;

  retp( cdfn(x) );
endp;

proc invcdf2(x);
  local m,sigma;

  x = missex(x, x.<0 .or x.> 1);

  m = a2'mu;
  sigma = sqrt(a2'*cov*a2);

  retp(m + sigma *cdfni(x) );
endp;

load c3;

proc pdf3(x);
  local pdf;

  pdf = dspline(c3,x,1);

  retp( pdf );
endp;

proc cdf3(x);
  local cdf;

  cdf = fspline(c3,x);

  retp( cdf );
endp;

proc invcdf3(x);
  local cdfi;

  x = missex(x, x.<0 .or x.> 1);

  cdfi = inv_spl(c3,x);

  retp(cdfi);
endp;


load c4;

proc pdf4(x);
  local pdf;

  pdf = dspline(c4,x,1);

  retp( pdf );
endp;

proc cdf4(x);
  local cdf;

  cdf = fspline(c4,x);

  retp( cdf );
endp;

proc invcdf4(x);
  local cdfi;

  x = missex(x, x.<0 .or x.> 1);

  cdfi = inv_spl(c4,x);

  retp(cdfi);
endp;

alphaGumbel = 2;

proc pdfCopula(x,y);
  retp( pdfCopulaGumbel(x,y,alphaGumbel) );
endp;

proc cdfCopula(x,y);
  retp( cdfCopulaGumbel(x,y,alphaGumbel) );
endp;


proc (2) = Bounds1(invcdf1,invcdf2,u,x);
  local invcdf1:proc,invcdf2:proc;
  local N,i,Fx,Fy,sum,ldb,udb;
  local max,min;

  N = rows(x);
  ldb = zeros(N,1);
  udb = zeros(N,1);
  i = 1;
  do until i > N;
    if x[i] == 0;
      Fx = invcdf1(0);
      Fy = invcdf2(0);
      ldb[i] = Fx + Fy;
    else;
      Fx = invcdf1(u);
      Fy = invcdf2(x[i]-u + 1);      
      ldb[i] = minc( selif(Fx + Fy, u .>= x[i] .and u .<= 1) );
    endif;

    if x[i] == 1;
      Fx = invcdf1(1);
      Fy = invcdf2(1);
      udb[i] = Fx + Fy;
    else;
      Fx = invcdf1(u);
      Fy = invcdf2(x[i]-u);      
      udb[i] = maxc( selif(Fx + Fy, u .>= 0 .and u .<= x[i]) );
    endif;

    i = i + 1;
  endo;

  retp(ldb,udb);
endp;


proc (2) = Bounds2(invcdf1,invcdf2,u,x);
  local invcdf1:proc,invcdf2:proc;
  local N,i,Fx,Fy,sum,ldb,udb;
  local max,min;

  N = rows(x);
  ldb = zeros(N,1);
  udb = zeros(N,1);
  i = 1;
  do until i > N;
    if x[i] == 0;
      Fx = invcdf1(0);
      Fy = invcdf2(0);
      ldb[i] = Fx + Fy;
    else;
      Fx = invcdf1(u);
      Fy = invcdf2(x[i]./u);      
      ldb[i] = minc( Fx + Fy );
    endif;

    if x[i] == 1;
      Fx = invcdf1(1);
      Fy = invcdf2(1);
      udb[i] = Fx + Fy;
    else;
      Fx = invcdf1(u);
      Fy = invcdf2((x[i]-u)./(1-u));      
      udb[i] = maxc( Fx + Fy );
    endif;

    i = i + 1;
  endo;

  retp(ldb,udb);
endp;

pr = seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|seqa(0.951,0.001,40);
pr = seqa(0.05,0.005,190);
pr = unique(pr,1);

xy(pr,invcdf1(pr)~invcdf3(pr));
xy(pr,invcdf2(pr)~invcdf4(pr));

/*
** Anal. I + Ana. II
*/

{ldb,udb} = Bounds1(&invcdf1,&invcdf2,pr,alpha);

print "Lower DB :";
print ldb;


/*
** Anal. I + Hist. II
*/

{ldb,udb} = Bounds1(&invcdf1,&invcdf4,pr,alpha);

print "Lower DB :";
print ldb;


/*
** Hist. I + Ana. II
*/

{ldb,udb} = Bounds1(&invcdf3,&invcdf2,pr,alpha);

print "Lower DB :";
print ldb;


/*
** Hist. I + Hist. II
*/

{ldb,udb} = Bounds1(&invcdf3,&invcdf4,pr,alpha);

print "Lower DB :";
print ldb;

alpha = seqa(0.80,0.01,18)|0.9725|0.9750|0.9775|0.98|0.9825|0.985|0.9875|0.990|0.991|0.992|0.993|0.994|0.9949;

{ldb1,udb} = Bounds1(&invcdf1,&invcdf2,pr,alpha);
{ldb2,udb} = Bounds1(&invcdf1,&invcdf4,pr,alpha);
{ldb3,udb} = Bounds1(&invcdf3,&invcdf2,pr,alpha);
{ldb4,udb} = Bounds1(&invcdf3,&invcdf4,pr,alpha);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|4; _plwidth = 10; _pcolor = 2|1|5|0;

  fonts("simplex simgrma");

  ytics(500,2000,250,2);
  xtics(0.80,1,0.05,2);

  xlabel("\216\202a\201");
  ylabel("\216Bornes de dependance");
  _pmsgstr = "\202\39\201";
  _pmsgctl = 0.37~3.94~0.16~90~2~0~6;

  _plegstr = "VaR]1[ analytique + VaR]2[ analytique\000VaR]1[ analytique + VaR]2[ historique"\
             "\000VaR]1[ historique + VaR]2[ analytique\000VaR]1[ historique + VaR]2[ historique";
  _plegctl = {2 4 3 5};

  graphprt("-c=1 -cf=agreg11.eps");

  xy(alpha,ldb1~ldb2~ldb3~ldb4);


