new;
library gdr,pgraph;
gdrset;

a = 3;
b = 1;

declare matrix _bound_x;

proc cdfGamma(x,a,b);
  local cdf; 
  cdf = cdfgam(a,x/b);
  retp(cdf);
endp;

proc invGamma(u,a,b);
  a = ones(rows(u),1) * a;
  retp( b * gammaii(a,u) );
endp;

fn cdf1(x) = cdfgamma(x,a,b);
fn cdf2(x) = cdfgamma(x,a,b);

proc invcdf1(x);
  x = missex(x, x.<0 .or x.> 1);
  retp( invGamma(x,a,b) );
endp;

proc invcdf2(x);
  x = missex(x, x.<0 .or x.> 1);
  retp( invGamma(x,a,b) );
endp;

pr = seqa(0.001,0.001,49)|seqa(0.05,0.005,190)|seqa(0.951,0.001,40);
pr = seqa(0.05,0.005,190);
pr = unique(pr,1);

alpha = seqa(0.90,0.005,19)|seqa(0.99,0.001,4)|seqa(0.994,0.0001,9);
alpha = unique(alpha,1);

u = alpha;

{ldb1,udb1} = DependencyBounds1(&invcdf1,&invcdf2,pr,u);
{ldb2,udb2} = DependencyBounds2(&invcdf1,&invcdf2,pr,u);

comon = invcdf1(u) + invcdf2(u);

proc pdf(x,y);
  local pdf1,pdf2;

  pdf1 = pdfgam(x,3);
  pdf2 = pdfgam(y,3);

  retp(pdf1 .* pdf2);
endp;

proc g1(x);
  retp(0);
endp;

proc g2(x);
  retp(_bound_x-x);
endp;

x_indep = seqa(5,.1,150);
F_indep = zeros(rows(x_indep),1);
_intord = 40;
_intrec = 0;

i = 1;
do until i > rows(x_indep);
  _bound_x = x_indep[i];
  F_indep[i] = intgrat2(&pdf,_bound_x|0,&g2|&g1);
  i = i + 1;
endo;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  _pframe = 0; _pnum = 2;
  fonts("simplex simgrma");

  _pltype = 1|3|1|3|6|6; _plwidth = 10; _pcolor = 2|1|4|5|3|4;
  xtics(0.90,1,0.01,2);
  ytics(5,20,2.5,2);
  xlabel("\216\202a\201");
  ylabel("\216F[-1]]1+2[(\202a\201)");

  setwind(1);
    _pmsgstr = "G[(-1)]]v[ avec C]-[ = C[-]"\
               "\000G[(-1)]]v[ avec C]-[ = C[\202\74\201]"\
               "\000F[-1] avec C = C[+]"\
               "\000F[-1] avec C = C[\202\74\201]"\
               "\000G[(-1)]]\202\76\201[ avec C]-[ = C[\202\74\201]"\
               "\000G[(-1)]]\202\76\201[ avec C]-[ = C[-]";
    _pmsgctl = 0.96~15.2~0.15~29~1~0~6 |
               0.91~12.20~0.15~12~1~0~6 |
               0.93~11.75~0.15~15~1~0~6 |
               0.905~9.5~0.15~8~1~0~6 |
               0.95~8.4~0.15~13~1~0~6 |
               0.92~6~0.15~7~1~0~6 ;
    xy(u,ldb1~ldb2~udb1~udb2~comon);
  setwind(2);
    xy(F_indep,x_indep);

    graphprt("-c=1 -cf=agreg10.eps");

  endwind;
