new;
library gdr,pgraph;
gdrSet;

rndseed 123;

let P0 = 244 135 315;
let theta = 2 -1 1;

thetaStar = theta .* P0;

let mu = 0.005 0.003 0.002;
let sigma = 0.020 0.030 0.010;

let cor = 1.0
          0.5 1.0
          0.25 0.60 1;

cor = xpnd(cor);
Sigma = cor .* sigma' .* sigma;

Nr = 20000;
n = 100|250;

VaR_hat = zeros(Nr,rows(n));

i = 1;
do until i > Nr;
  j = 1;
  do until j > rows(n);
    rs = mu' + rndn(n[j],3)*chol(Sigma);
    mu_hat = meanc(rs);
    Sigma_hat = vcx(rs);
    VaR_hat[i,j] = -thetaStar'mu_hat + cdfni(0.99)*sqrt(thetaStar'*Sigma_hat*thetaStar);
    j = j + 1;
    endo;
  i = i + 1;
endo;

_Kernel[1:3] = 10|26|256;
d = zeros(256,rows(n));
j = 1;
do until j > rows(n);
  {x,d[.,j],F,retcode} = Kernel(VaR_hat[.,j]);
  j = j + 1;
endo;

VaR = -thetaStar'mu + cdfni(0.99)*sqrt(thetaStar'*Sigma*thetaStar);

graphset;
  _pdate = ""; _pframe = 0; _pnum = 2; 
  _plwidth = 10; _pcolor = 2|4;
  xlabel("\216VaR");
  ytics(0,0.36,0.06,6);
  _pline = 1~6~VaR~0~VaR~1~1~0~10;
  _plegstr = "n = 100\000n = 250";
  _plegctl = {2 7 6.5 4};
  graphprt("-c=1 -cf=var8-1.eps");
  xy(x,d);

c = seqa(0.001,0.001,10)|seqa(0.01,0.01,50);
ratio = abs((VaR_Hat-VaR)/VaR);
beta = zeros(rows(c),2);

i = 1;
do until i > rows(c);
  beta[i,.] = meanc(ratio .<= c[i])';
  i = i + 1;
endo;


graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pframe = 0; _pnum = 2; 
  _plwidth = 10;  _pcolor = 2|4;
  xlabel("\216c (en %)");
  ylabel("\216\202b\201 (en %)");  
  xtics(0,50,5,2);
  ytics(0,100,10,2);
  _plegstr = "n = 100\000n = 250";
  _plegctl = {2 7 6.5 4};
  graphprt("-c=1 -cf=var8-2.eps");
  xy(100*c,100*beta);