new;
library gdr,pgraph;
gdrSet;

_LogReturn = 0;

rndseed 123;

load Prices[251,3] = test1.dat;

let P0 = 244 135 315;
let theta = 2 -1 1;

r = packr(LogReturn(Prices,_LogReturn));

mu = meanc(r);
Sigma = vcx(r);

ns = 100000;
rs = mu' + rndn(ns,3)*chol(Sigma);

Ps = P0' .* (1+rs); 
PnL = Ps*theta - P0'theta; 

output file = var6.out reset;

VaR = -quantile(PnL,0.01);
print ftos(VaR,"Monte-Carlo VaR(0.99) = %lf",5,2);
thetaStar = theta .* P0;
VaR = -thetaStar'mu + cdfni(0.99)*sqrt(thetaStar'*Sigma*thetaStar);
print ftos(VaR,"Theoretical VaR(0.99) = %lf",5,2);

output off;          

graphset;
  _pdate = ""; _pframe = 0; _pnum = 2; 
  _pbartyp = 6~5;
  xlabel("\216Variation (en euros)");
  ylabel("\214  ");
  graphprt("-c=1 -cf=var6.eps");
  call histp(PnL,250);




