new;
library gdr,pgraph;
gdrSet;

_LogReturn = 0;

load Prices[251,3] = test1.dat;

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,0);
  makewind(9/2,6.855/2,9/2,6.855/2,0);
  makewind(9/2,6.855/2,9/4,0,0);

  _pdate = ""; _pframe = 0; _pnum = 2; 
  _ptitlht = 0.25; _paxht = 0.22; _pnumht = 0.20;
  _plwidth = 10;
  xtics(0,250,50,5);
  xlabel("\216Temps");
  
  setwind(1);
    _pcolor = 2;
    title("\216Actif A");
    xy(seqa(1,1,rows(Prices)),Prices[.,1]);

  setwind(2);
    _pcolor = 1;
    title("\216Actif B");
    xy(seqa(1,1,rows(Prices)),Prices[.,2]);

  setwind(3);
    _pcolor = 4;
    title("\216Actif C");
    xy(seqa(1,1,rows(Prices)),Prices[.,3]);

    graphprt("-c=1 -cf=var5-1.eps");

  endwind;

let P0 = 244 135 315;
let theta = 2 -1 1;

r = LogReturn(Prices,_LogReturn);
P = P0' .* (1+r);                               /* Calcul de P(t+1) en applicant les chocs historiques */
PnL = P*theta - P0'theta;                       /* Variation du P&L entre t et t+1                     */
PnLs = sortc(PnL,1);                            /* P&L Tris  */

output file = var5.out reset;
let fmt[1,3] = "%lf" 10 2;
call printfm(Prices[1:13,.]~100*r[1:13,.]~P[1:13,.]~PnL[1:13],1,fmt);
print;
call printfm(PnLs[1:13,.],1,fmt);
output off;

graphset;
  begwind;
  window(2,2,1);

  _pdate = ""; _pframe = 0; _pnum = 2; 
  _ptitlht = 0.25; _paxht = 0.22; _pnumht = 0.18;
  _plwidth = 10;
  
  r = packr(100*r);
  xlabel("\216Rendement (en %)");
  ylabel("\216  ");

  setwind(1);
    _pbartyp = 6~2;
    title("\216Actif A");
    call histp(r[.,1],50);

  setwind(2);
    _pbartyp = 6~1;
    title("\216Actif B");
    call histp(r[.,2],50);

  setwind(3);
    _pbartyp = 6~4;
    title("\216Actif C");
    call histp(r[.,3],50);

  setwind(4);
    _pbartyp = 6~5;
    title("\216PnL");
    xlabel("\216Variation (en euros)");
    call histp(packr(PnL),50);

    graphprt("-c=1 -cf=var5-2.eps");

  endwind;
