new;
library gdr,pgraph;

cls;

Let A[4,3] = 1.2 0.9 0
             1.3 0.3 0
             1.4 0 0.0
             1.0 0 0.5;

let sigma_F = 0.20 0.15 0.10;
Omega = diagrv(eye(3),sigma_F^2);
let sigma_A = 0.10 0.15 0.10 0.15;
D = diagrv(eye(4),sigma_A^2);

cov = A*Omega*A' + D;
sigma = sqrt(diag(cov));
rho = cov ./ sigma ./ sigma';

dt = 1/12;
alpha = 0.99;

let x = 250 125 200 300;

{VaR,mr,rc} = VaR_Decomposition(alpha,x,cov,A,Omega,D,0);

VaR = VaR * sqrt(dt);
rc = rc * sqrt(dt);
mr = mr * sqrt(dt);
VaR_A = VaR;
mr_A = mr;

Results = (mr~rc)~(rc/VaR_A);
let fmt[1,3] = "%lf" 10 3;
print "Risk Contributions by Assets :";
call printfm(Results,1,fmt);

{VaR,mr,rc} = VaR_Decomposition(alpha,x,cov,A,Omega,D,1);

VaR = VaR * sqrt(dt);
rc = rc * sqrt(dt);
mr = mr * sqrt(dt);
VaR_F = VaR;

Results = (mr~rc)~(rc/VaR_A);
print "Risk Contributions by Factors :";
call printfm(Results,1,fmt);

print ftos(VaR_A,"VaR = %lf",5,2);
print ftos(100*VaR_A/sumc(x),"VaR (in percent) = %lf",5,2);
print ftos(VaR_F,"VaR (factors) = %lf",5,2);
print ftos(sumc(rc),"VaR (factors) = %lf",5,2);
diff = VaR_F/VaR_A;
print ftos(100*diff,"VaR explained by the factors in percent = %lf",5,2);

new_x = x;
new_x[1] = new_x[1] + 1;
{VaR,mr,rc} = VaR_Decomposition(alpha,new_x,cov,A,Omega,D,0);
VaR = VaR * sqrt(dt);

print VaR-VAR_A;

new_x = x;
new_x[1] = new_x[1] + 100;
{VaR,mr,rc} = VaR_Decomposition(alpha,new_x,cov,A,Omega,D,0);
VaR = VaR * sqrt(dt);

print VaR-VAR_A;

let new_x = 280 120 180 235;
delta = new_x - x;
dVaR = sumc(delta .* mr_A);
print dVaR;

{VaR,mr,rc} = VaR_Decomposition(alpha,new_x,cov,A,Omega,D,0);
VaR = VaR * sqrt(dt);
print VAR-VaR_A;
