new;
library gdr,pgraph;
gdrSet;

cls;

let sigma = 0.20 0.30 0.30;

let rho = 1.0
          0.5 1.0
          -0.50 -0.50 1;
rho = xpnd(rho);
sigma = rho .* sigma' .* sigma;
call invpd(sigma);

let x = 0.50 0.40 0.10;

dt = 1/12;
alpha = 0.99;
kappa = cdfni(alpha) * sqrt(dt);

VaR = kappa * sqrt(x'Sigma*x);
mVaR = kappa * (Sigma * x) / sqrt(x'Sigma*x);
RC = x .* mVaR;

beta = (Sigma * x) / (x'Sigma*x);

IVaR = zeros(3,1);
y = x;
y[1] = 0.0;
IVaR[1] = kappa * sqrt(y'Sigma*y);
y = x;
y[2] = 0.0;
IVaR[2] = kappa * sqrt(y'Sigma*y);
y = x;
y[3] = 0.0;
IVaR[3] = kappa * sqrt(y'Sigma*y);
IVaR = VaR - IVaR;

Results = x~mVaR~RC~IvAR~Beta~(x .* Beta .* VaR);
s = sumc(Results);
s[1 2 4 5] = error(0) * s[1 2 4 5];
Results = Results | s';

let fmt[1,3] = "%lf" 10 3;
call printfm(Results,1,fmt);

print ftos(VaR,"VaR = %lf",10,3);

