new;
library gdr,pgraph;
gdrSet;

load Prices[251,3] = test1.dat;
S = Prices[.,1];
r = LogReturn(S,1);
r = trimr(r,1,0);

S_t = 244;

K = 250;
tau = 1;
ir = 0.05;
sigma_t = 0.23;
C_t = EuropeanBS(S_t,K,sigma_t,tau,ir);
shock = 1e-4;
Delta_t = (EuropeanBS(S_t*(1+shock),K,sigma_t,tau,ir) - EuropeanBS(S_t,K,sigma_t,tau,ir))/(shock*S_t);

theta1 = -1;
theta2 = 10;
P_t = theta1*S_t + theta2*C_t;

S_tp1 = S_t .* (1+r);
C_tp1 = EuropeanBS(S_tp1,K,sigma_t,tau-1/365,ir);
P_tp1 = theta1*S_tp1 + theta2*C_tp1;
PnL = P_tp1 - P_t; 

PnL1 = (S_tp1 - S_t);
PnL2 = (C_tp1 - C_t);

VaR = -quantile(PnL,0.01);
print VaR;

n = 100000;
mu_r = meanc(r);
sigma_r = stdc(r);
rs = mu_r + rndn(n,1) * sigma_r;
S_tp1 = S_t .* (1+rs);
C_tp1 = EuropeanBS(S_tp1,K,sigma_t,tau-1/365,ir);
P_tp1 = theta1*S_tp1 + theta2*C_tp1;
PnL_MC = P_tp1 - P_t; 

VaR_MC = -quantile(PnL_MC,0.01);
print VaR_MC;

PnL_Delta = (theta1+theta2*Delta_t)*S_t.*r; 
VaR_Delta = -quantile(PnL_Delta,0.01);
print VaR_Delta;

graphset;
  begwind;
  window(2,2,0);
  
  fonts("simplex simgrma");
  _pdate = ""; _pframe = 0; _pnum = 2; 
  _ptitlht = 0.25; _paxht = 0.25; _pnumht = 0.18;
  _plwidth = 10;

  setwind(1);
    _plctrl = -1; _pcolor = 1;
    xlabel("\216PnL]1[");
    ylabel("\216PnL]2[");
    xtics(-15,15,5,2);
    ytics(-10,10,5,2);
    xy(PnL1,PnL2);
  setwind(2);
    _pbartyp = 6~2;
    title("\216VaR historique\L\216(full pricing)");
    xlabel("\216PnL");
    ylabel("\216Frequence (en %)");
    _pmsgstr = "\202\39\201";
    _pmsgctl = 0.4~2.0~0.20~90~2~0~6;
    xtics(-80,80,20,2);
    ytics(0,7,1,2);
    call histp(PnL,50);
  setwind(3);
    _pmsgctl = 0.4~2.25~0.20~90~2~0~6;
    _pbartyp = 6~5;
    title("\216VaR Monte Carlo");
    ytics(0,1.5,0.5,2);
    call histp(PnL_MC,250);
  setwind(4);
    _pmsgctl = 0.4~2.0~0.20~90~2~0~6;
    _pbartyp = 6~4;
    title("\216VaR historique\L\216(approche delta)");
    ytics(0,7,1,2);
    call histp(PnL_Delta,50);
    graphprt("-c=1 -cf=var23.eps");
  endwind;







