new;
library gdr,pgraph,option;

rndseed 123;

S0 = 100;
K = 100;
Sigma0 = 0.20;
tau = 52/252;
r = 0.05;

C0 = EuropeanBS(S0,K,sigma0,tau,r,r);
fn Call_Option(S) = EuropeanBS(S,K,sigma0,tau,r,r);
Delta0 = EuropeanBS_Delta(S0,K,sigma0,tau,r,r);
Gamma0 = EuropeanBS_Gamma(S0,K,sigma0,tau,r,r);
G0 = hessp(&Call_Option,S0);
Theta0 = EuropeanBS_Theta(S0,K,sigma0,tau,r,r);

cls;

outwidth 256;
output file = var21.out reset;

print ftos(C0,"C0 = %lf",10,3);
print ftos(Delta0,"Delta0 = %lf",10,3);
print ftos(Gamma0,"Gamma0 = %lf",10,3);
print ftos(Theta0,"Theta0 = %lf",10,3);

tau = tau - 1/252;

ns = 1000000;
dt = 1/252;
Sigma1 = Sigma0;

rndseed 123456;
R_S = rndn(ns,1) * Sigma1 * sqrt(dt);

S1 = S0 .* (1 + R_S);
C1 = EuropeanBS(S1,K,sigma1,tau,r,r);
PnL1 = C1 - C0;

PnL2 = Delta0 * (S1 - S0);
PnL3 = Delta0 * (S1 - S0) + 0.5 * Gamma0 * (S1 - S0)^2;

PnL4 = Delta0 * (S1 - S0) + 0.5 * Gamma0 * (S1 - S0)^2 + Theta0 * dt;

Results = 100*R_S~S1~C1~PnL1~PnL2~PnL3~PnL4;

let fmt[1,3] = "%lf" 10 2;
call printfm(Results[1:10,.],1,fmt);

VaR1 = -quantile(PnL1,0.01);
VaR2 = -quantile(PnL2,0.01);
VaR3 = -quantile(PnL3,0.01);
VaR4 = -quantile(PnL4,0.01);

print ftos(VaR1,"VaR1 = %lf",10,3);
print ftos(VaR2,"VaR2 = %lf",10,3);
print ftos(VaR3,"VaR3 = %lf",10,3);
print ftos(VaR4,"VaR4 = %lf",10,3);

output off;