new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac;
indx = indsav(selected_names,vnames);
data = data[.,indx];

Dates = data[.,1];
nDates = rows(Dates);
CaC = data[.,2];

Rdt = CaC./lag1(CAC) - 1;

Nominal = 1e6;
let Length = 250;
nLength = rows(Length);

VaR = miss(zeros(nDates,3),0);

alpha = 0.99;

lambda = 0.94;
h2 = 0;

i = 1;
do until i > nDates;

  j = 1;
  do until j > nLength;
    if i-length < 1;
      j = j + 1;
      continue;
    endif;
    VaR[i,1] = -quantile(Rdt[i:i-length[j]],1-alpha);
    VaR[i,2] = 2.33 * stdc(packr(Rdt[i:i-length[j]]));
    u = Rdt[i];
    h2 = lambda .* h2 + (1-lambda) * u^2;
    VaR[i,3] = 2.33 * sqrt(h2);

    j = j + 1;
  endo;

  i = i + 1;
endo;

VaR = Nominal * VaR;
Loss = -Nominal * lagn(Rdt,-1);

VaR = selif(VaR, (Dates .>= 20080101) .and (Dates .<= 20081231));
Loss = selif(Loss, (Dates .>= 20080101) .and (Dates .<= 20081231));
t = seqa(1,1,rows(VaR));
indx = selif(t,Loss .>= VaR[.,1]);
indx = indx | selif(t,Loss .>= VaR[.,2]);
indx = indx | selif(t,Loss .>= VaR[.,3]);
nEx = sumc(Loss .>= VaR);

e = ones(rows(indx),1);
x = t[indx];
y = Loss[indx];

sym = 8*ones(nEx[1],1) | 9*ones(nEx[2],1) | 12*ones(nEx[3],1);
siz = 7*ones(nEx[1],1) | 4*ones(nEx[2],1) | 2*ones(nEx[3],1);
clr = 3*ones(nEx[1],1) | 12*ones(nEx[2],1) | 1*ones(nEx[3],1);

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 3|1|6; _plwidth = 10; _pcolor = 3|12|1;
  xtics(1,12*22,22,1);
  ytics(0,12e4,2e4,0);
  let xlab = "Jan" "Fev" "Mar" "Apr" "May" "Jun" "Jul" "Aug" "Sep" "Oct" "Nov" "Dec";
  asclabel(xlab,0);
  _plegstr = "VaR historique\000VaR gaussienne\000VaR GARCH avec \202l\201 = 0.94";
  _plegctl = {2 5 2 5};
  _psym = x~y~sym~siz~clr~e.*(1~10);
  graphprt("-c=1 -cf=VaR20.eps");
  xy(0,VaR[.,1 2 3]);
