new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac;
indx = indsav(selected_names,vnames);
data = data[.,indx];

Dates = data[.,1];
nDates = rows(Dates);
CaC = data[.,2];

Nominal = 1e6;

Rdt = CaC./lag1(CAC) - 1;

let Length = 250 500 750;
nLength = rows(Length);

VaR = miss(zeros(nDates,nLength),0);

VaR1 = VaR; VaR2 = VaR; VaR3 = VaR; VaR4 = VaR;
alpha = 0.99|0.95;

i = 1;
do until i > nDates;

  j = 1;
  do until j > nLength;
    if i-length[j] < 1;
      j = j + 1;
      continue;
    endif;
    VaR = -quantile(Rdt[i:i-length[j]],1-alpha);
    VaR1[i,j] = VaR[1];
    VaR2[i,j] = VaR[2];

    sigma = stdc(Rdt[i:i-length[j]]);
    VaR3[i,j] = cdfni(0.99)*sigma;
    VaR4[i,j] = cdfni(0.95)*sigma;

    j = j + 1;
  endo;

  i = i + 1;
endo;

VaR1 = Nominal * VaR1;
VaR2 = Nominal * VaR2;
VaR3 = Nominal * VaR3;
VaR4 = Nominal * VaR4;

VaR1 = selif(VaR1,Dates .>= 19900101);
VaR2 = selif(VaR2,Dates .>= 19900101);
VaR3 = selif(VaR3,Dates .>= 19900101);
VaR4 = selif(VaR4,Dates .>= 19900101);

graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|4;
  _paxht = 0.225; _pnumht = 0.225; _ptitlht = 0.25;
  xtics(1,260*20,5*260,1);
  let xlab = "90" "95" "2000" "05" "10";
  asclabel(xlab,0);

  setwind(1);
    ytics(0,80000,10000,2);
    title("\216VaR]H[(99%)");
    xy(0,VaR1);

  setwind(2);
    title("\216VaR]H[(95%)");
    ytics(0,50000,10000,2);
    xy(0,VaR2);

  setwind(3);
    title("\216VaR]A[(99%)");
    ytics(0,80000,10000,2);
    xy(0,VaR3);

  setwind(4);
    title("\216VaR]A[(95%)");
    ytics(0,50000,10000,2);
    _plegstr = "1 an\0002 ans\0003 ans";
    _plegctl = {2 5 2 4};
    xy(0,VaR4);

    graphprt("-c=1 -cf=var18.eps");

  endwind;
