new;
library gdr,pgraph;
gdrSet;

cls;

rndseed 123;

let mu = 0.005 0.003 0.002;
let sigma = 0.020 0.030 0.010;

let cor = 1.0
          0.5 1.0
          0.25 0.60 1;

cor = xpnd(cor);
df = 4;

let P = 244 135 315;
let theta = 2 -1 1;
thetaStar = theta .* P;

n = 251;
Nr = 500;
alpha = 0.99;

VaR = zeros(Nr,2);

i = 1;
do until i > Nr;
  r = rndCopulaNormal(cor,n);
  r = mu' + sigma' .* cdfti(r,df);

  mu_hat = meanc(r);
  Sigma_hat = vcx(r);
  VaR[i,1] = - thetaStar'mu_hat + cdfni(alpha) * sqrt(thetaStar'Sigma_hat*thetaStar);
  VaR[i,2] = -quantile(r*thetaStar,1-alpha);

  i = i + 1;
endo;

n = 1e5;
r = rndCopulaNormal(cor,n);
r = mu' + sigma' .* cdfti(r,df);
VaR_MC = -quantile(r*thetaStar,1-alpha);

_Kernel[1:3] = 0|70|256;
d = zeros(256,2);
i = 1;
do until i > 2;
  {x,d[.,i],F,retcode} = Kernel(VaR[.,i]);
  i = i + 1;
endo;

graphset;
  _pdate = ""; _pframe = 0; _pnum = 2; 
  _plwidth = 10; _pcolor = 1|4;
  xlabel("\216VaR");
  xtics(10,50,10,2);
  ytics(0,0.14,0.02,2);
  _pline = 1~6~VaR_MC~0~VaR_MC~1~1~0~10;
  _plegstr = "VaR analytique\000VaR historique";
  _plegctl = {2 5 6 5};
  graphprt("-c=1 -cf=var15.eps");
  xy(x,d);

