new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

r = ln(data[.,2 3]);
r = r - lag1(r);

r = packr(r);
y = r;

mu = meanc(r);
vc = vcx(r);

{mu1,mu2,sigma1,sigma2,rho} = cov2D(mu,vc);

c = cdfchii(0.99,2);
e = InCovarianceEllipse2(y[.,1],y[.,2],mu1,mu2,sigma1,sigma2,rho,c);
print 1-sumc(e)/rows(y);

alpha = 0.0001|seqa(0.01,0.01,94)|seqa(0.95,0.001,49)|0.9999;
alpha1 = zeros(rows(alpha),1);
i = 1;
do until i > rows(alpha);
  c = cdfchii(alpha[i],2);
  e = InCovarianceEllipse2(y[.,1],y[.,2],mu1,mu2,sigma1,sigma2,rho,c);
  alpha1[i] = sumc(e)/rows(y);
  i = i + 1;
endo;

alpha = 0|alpha;
alpha1 = 0|alpha1;

graphset;
  _pdate = ""; _pltype = 3; _pnum = 2; _pframe = 0; _plwidth = 10; _pcolor = 2|5;
  fonts("simplex simgrma");
  xlabel("\216Niveau de confiance theorique");
  ylabel("\216Niveau de confiance empirique");
  _pline = 1~6~0~0~1~1~1~0~10;
  _pmsgstr = "\202\39\201";
  _pmsgctl = 9*2625/4091~6.855*100/3120~0.17~0~2~0~6;
  graphprt("-c=1 -cf=var14.eps");
  xy(alpha,alpha1);


