new;
library gdr,pgraph;
gdrSet;

mu = 0;
sigma = 1;

proc pdfn2(x);
  retp( pdfn((x-mu)./sigma)./sigma);
endp;

x = seqa(-4,0.1,81);
y0 = pdfn2(x);

proc edgeworth(varsigma,kappa,x);
  local y;
  y = 1 + 
      varsigma .* (x^3 - 3*x) / 6 +
      (kappa - 3) .* (x^4 - 6*x^2 + 3) / 24 +
      (varsigma^2) .* (x^5 - 10*x^3 + 15*x) / 72;
  retp( y .* pdfn2(x) );
endp;

y1 = edgeworth(-0.7,3,x);
y2 = edgeworth(0.8,3,x);  
y3 = edgeworth(0,1.5,x);  
y4 = edgeworth(0,4.5,x);  
y5 = edgeworth(-0.5~0.8~-1,5.5~2.5~6.5,x); 
e = 0.5 * (trimr(x,1,0) - trimr(x,0,1)) .* (trimr(y5,1,0) + trimr(y5,0,1));
e = e .* (e .> 0);
F5 = cumsumc(e);

graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,0);
  makewind(9/2,6.855/2,0,0,0);
  makewind(9/2,6.855/2,9/2,0,0);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|4; _plwidth = 10; 
  _pnumht = 0.20;
  _pcolor = 2|4|5;
  xtics(-4,4,1,2);
  ytics(0,0.5,0.1,10);

  h = 0.25;

  setwind(1);
    _pmsgstr = "\201Distribution normale";
    _pmsgctl = 0.18~0.425~h~0~1~0~7;
    xy(x,y0);

  setwind(2);
    _pmsgstr = "\201asymetrie droite\000(\202c\201]3[=-0.7)\000asymetrie gauche\000   (\202c\201]3[=0.7)" $+
               "\000\202\39\201\000\202\39\201";
    _pmsgctl = -3.95~0.35~h~0~1~0~6|
               -3.5~0.30~h~0~1~0~6|
                1.0~0.35~h~0~1~0~6|
                1.0~0.30~h~0~1~0~6|
                1.9~4.9~0.20~0~2~0~6|
                6.75~4.9~0.20~0~2~0~6;
    xy(x,y0~y1~y2);

  setwind(3);
    _pmsgstr = "\201platikurtique\000(\202c\201]4[=1.5)\000leptokurtique\000   (\202c\201]4[=4.5)";
    _pmsgctl = -3.65~0.20~h~0~1~0~6|
               -3.65~0.15~h~0~1~0~6|
                0.42~0.425~h~0~1~0~6|
                0.40~0.375~h~0~1~0~6;
    xy(x,y0~y3~y4);

    graphprt("-c=1 -cf=var13.eps");

  endwind;