new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

dates = data[.,1];        /* Date    */
CAC40 = data[.,2];        /* CAC 40  */
DJ = data[.,3];           /* Dow Jones  */

r = ln(data[.,2 3]);
r = r - lag1(r);

r = packr(r);
mu = meanc(r);
sigma = stdc(r);
r = (r - mu') ./ sigma';
_Kernel[1:3] = -6|7|512;
{x,d1,F1,retcode} = Kernel(r[.,1]);
{x,d2,F2,retcode} = Kernel(r[.,2]);

{dates,data} =Generate_Monthly_Data(Dates,Data,19850101,20090101);
nDates = rows(data);

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pframe = 0; _pnum = 2; _pysci = 5; 
  _pnumht = 0.20; _paxht = 0.22; _ptitlht = 0.25;
  _plwidth = 10; 
  fonts("simplex simgrma");

  setwind(1);
    title("\216CAC 40");
    _pcolor = 2;
    xtics(1,nDates,12*5,0);
    ytics(0,7000,1000,2);
    let lab = "1985" "1990" "1995" "2000" "2005" "2010";
    asclabel(lab,0);
    xlabel("\216Date");
    xy(seqa(1,1,nDates),data[.,2]);

  setwind(2);
    title("\216Dow Jones");
    _pcolor = 4;
    ytics(0,14000,2000,2);  
    xy(seqa(1,1,nDates),data[.,3]);

    _plwidth = 10;
    asclabel(0,0); 
    _pmsgstr = "\202\39\201";
    xlabel("\216Rendement normalise");
    title("");

    _pmsgctl = 6.4~0.25~0.20~0~2~0~6;
  setwind(3);
    _pltype = 6|1|3;
    _pcolor = 5|2|4;
    xtics(-6,6,2,2);
    ytics(0,0.6,0.1,2);
    xy(x,pdfn(x)~d1~d2);

    _pmsgctl = 6.5~0.25~0.20~0~2~0~6;
  setwind(4);
    y = seqa(3,0.01,401);
    e = ones(rows(y),1);
    xtics(3,7,0.5,2)
    ytics(0,0.0035,0.001,2);
    _plegstr = "Distribution normale\000CAC 40\000Dow Jones";
    _plegctl = {2 6 4.25 5};
    _pline = e.*(1~6)~y~e.*0~y~pdfn(y)~e.*(1~0~0);
    xy(x,pdfn(x)~d1~d2);

    graphprt("-c=1 -cf=var11.eps");

  endwind;

