new;
library gdr,pgraph;
gdrSet;

rndseed 123;

let P0 = 244 135 315;
let theta = 2 -1 1;

thetaStar = theta .* P0;

let mu = 0.005 0.003 0.002;
let sigma = 0.020 0.030 0.010;

let cor = 1.0
          0.5 1.0
          0.25 0.60 1;

cor = xpnd(cor);
Sigma = cor .* sigma' .* sigma;

Nr = 20000;
n = 100|250;

VaR_hat = zeros(Nr,rows(n));
d = zeros(256,rows(n));
c = seqa(0.001,0.001,10)|seqa(0.01,0.01,50);
beta = zeros(rows(c),2);

alpha = 0.99;

i = 1;
do until i > Nr;
  j = 1;
  do until j > rows(n);
    rs = mu' + rndn(n[j],3)*chol(Sigma);
    PnL = rs*thetaStar;                    
    VaR = -quantile(PnL,1-alpha);
    VaR_hat[i,j] = -quantile(PnL,1-alpha);
    j = j + 1;
    endo;
  i = i + 1;
endo;

_Kernel[1:3] = 10|26|256;
j = 1;
do until j > rows(n);
  {x,d[.,j],F,retcode} = Kernel(VaR_hat[.,j]);
  j = j + 1;
endo;

VaR = -thetaStar'mu + cdfni(alpha)*sqrt(thetaStar'*Sigma*thetaStar);
ratio = abs((VaR_Hat-VaR)/VaR);
i = 1;
do until i > rows(c);
  beta[i,.] = meanc(ratio .<= c[i])';
  i = i + 1;
endo;

x1 = x;
d1 = d;
beta1 = beta;
VaR1 = VaR;

alpha = 0.95;

i = 1;
do until i > Nr;
  j = 1;
  do until j > rows(n);
    rs = mu' + rndn(n[j],3)*chol(Sigma);
    PnL = rs*thetaStar;                    
    VaR = -quantile(PnL,1-alpha);
    VaR_hat[i,j] = -quantile(PnL,1-alpha);
    j = j + 1;
    endo;
  i = i + 1;
endo;

_Kernel[1:3] = 6|18|256;
j = 1;
do until j > rows(n);
  {x,d[.,j],F,retcode} = Kernel(VaR_hat[.,j]);
  j = j + 1;
endo;

VaR = -thetaStar'mu + cdfni(alpha)*sqrt(thetaStar'*Sigma*thetaStar);
ratio = abs((VaR_Hat-VaR)/VaR);
i = 1;
do until i > rows(c);
  beta[i,.] = meanc(ratio .<= c[i])';
  i = i + 1;
endo;

x2 = x;
d2 = d;
beta2 = beta;
VaR2 = VaR;

graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");

  _pdate = ""; _pframe = 0; _pnum = 2; 
  _pnumht = 0.20; _paxht = 0.22; _ptitlht = 0.25;
  _plwidth = 10; _pcolor = 2|4;

  setwind(1);
    title("\216\202a\201 = 99%");
    xlabel("\216VaR");
    xtics(12,26,2,2);
    ytics(0,0.20,0.05,2);
    _pline = 1~6~VaR1~0~VaR1~1~1~0~10;
    xy(x1,d1);

  setwind(2);
    title("\216\202a\201 = 95%");
    xtics(6,18,2,2);
    ytics(0,0.36,0.08,2);
    _pline = 1~6~VaR2~0~VaR2~1~1~0~10;
    xy(x2,d2);

  setwind(3);
    title("\216\202a\201 = 99%");
    _pline = 0;
    xlabel("\216c (en %)");
    ylabel("\216\202b\201 (en %)");  
    xtics(0,50,10,2);
    ytics(0,100,20,2);
    xy(100*c,100*beta1);

  setwind(4);
    title("\216\202a\201 = 95%");
    _plegstr = "n = 100\000n = 250";
    _plegctl = {2 7 6 4};
    xy(100*c,100*beta2);

    graphprt("-c=1 -cf=var10.eps");

  endwind;

