new;
library gdr,,pgraph,optmum;

cls;

datFileName = "..\\data\\data-bonds.dat";
data = loadd(datFileName);

Dates = data[.,1];
R = data[.,2:6];
Sp = data[.,7];
n = rows(R);
R_0 = R[n,.]';
Sp_0 = Sp[n,.];
RR_0 = 0.50;

Notional = 1e6;
P0 =  Risky_Bond_Price(R_0,Sp_0,RR_0,0);

nB = Notional/P0;

dR = R - lag1(R);
dSp = Sp - lag1(Sp);

R = R_0 + dR';
Sp = Sp_0 + dSp';

nS = 250;
nT = rows(dR);
P = zeros(nT,nS);

alpha = 0.99;

rndseed 123;

i = 1;
do until i > nS;
  RR = 0.40 + rndu(nT,1) * 0.20;
  P[.,i] =  Risky_Bond_Price(R,Sp,RR,1);
  i = i + 1;
endo;
P = packr(vec(P));
PnL = nB * (P - P0);
hVaR = -quantile(PnL,1-alpha);

RR = 0.50;
P =  Risky_Bond_Price(R,Sp,RR,1);
PnL2 = nB * (P - P0);

print;
print ftos(hVaR,"VaR historique(0.99) = %lf",5,2);

_Kernel[1:3] = -20000|20000|256;
{x,d,F,retcode} = Kernel(PnL);
{x,d2,F,retcode} = Kernel(PnL2);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0; _pysci = 1;
  _pltype = 6|3; _plwidth = 10; _pcolor = 1|2;
  _plegstr = "Taux de recouvrement stochastique\000Taux de recouvrement constant";
  _plegctl = {2 4 5 3.5};
  graphprt("-c=1 -cf=var-credit4.eps");
  xy(x,d~d2);

proc (1) = Risky_Bond_Price(R,Spread,RR,h);
  local C,T,S,B,P;

  let C = 5 5 5 5 105;
  let T = 1 2 3 4 5;

  T = T - h/260;

  S = exp(-Spread .* T);
  B = exp(-R .* T);
  P = sumc(C .* B .* S) + RR .* (1 - S[5,.]') .* B[5,.]' .* 100;

  retp(P);
endp;
